@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetVcenterControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 * @property vcenterName  VCenters name
 */
public data class GetVcenterControllerPlainArgs(
    public val resourceGroupName: String,
    public val siteName: String,
    public val vcenterName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetVcenterControllerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.GetVcenterControllerPlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetVcenterControllerPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 }))
            .vcenterName(vcenterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVcenterControllerPlainArgs].
 */
@PulumiTagMarker
public class GetVcenterControllerPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var siteName: String? = null

    private var vcenterName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vmnphkpytdfdbtun")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("qqffcegunauvpuqv")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    /**
     * @param value  VCenters name
     */
    @JvmName("gusxhejechchfexc")
    public suspend fun vcenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vcenterName = mapped
    }

    internal fun build(): GetVcenterControllerPlainArgs = GetVcenterControllerPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
        vcenterName = vcenterName ?: throw PulumiNullFieldException("vcenterName"),
    )
}
