@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.SiteAppliancePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for site appliance properties.
 * @property agentDetails Gets or sets the on-premises agent details.
 * @property applianceName Gets or sets the Appliance Name.
 * @property servicePrincipalIdentityDetails  Gets or sets the service principal identity details used by agent for  communication              to the service.
 */
public data class SiteAppliancePropertiesArgs(
    public val agentDetails: Output<SiteAgentPropertiesArgs>? = null,
    public val applianceName: Output<String>? = null,
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.SiteAppliancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.SiteAppliancePropertiesArgs =
        com.pulumi.azurenative.offazure.inputs.SiteAppliancePropertiesArgs.builder()
            .agentDetails(agentDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .applianceName(applianceName?.applyValue({ args0 -> args0 }))
            .servicePrincipalIdentityDetails(
                servicePrincipalIdentityDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [SiteAppliancePropertiesArgs].
 */
@PulumiTagMarker
public class SiteAppliancePropertiesArgsBuilder internal constructor() {
    private var agentDetails: Output<SiteAgentPropertiesArgs>? = null

    private var applianceName: Output<String>? = null

    private var servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("djyajbhsbyooqewm")
    public suspend fun agentDetails(`value`: Output<SiteAgentPropertiesArgs>) {
        this.agentDetails = value
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("rnyucnojofcebjel")
    public suspend fun applianceName(`value`: Output<String>) {
        this.applianceName = value
    }

    /**
     * @param value  Gets or sets the service principal identity details used by agent for  communication              to the service.
     */
    @JvmName("prysuxabkyceyhpl")
    public suspend fun servicePrincipalIdentityDetails(`value`: Output<SiteSpnPropertiesArgs>) {
        this.servicePrincipalIdentityDetails = value
    }

    /**
     * @param value Gets or sets the on-premises agent details.
     */
    @JvmName("brhffixhhtluodvw")
    public suspend fun agentDetails(`value`: SiteAgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentDetails = mapped
    }

    /**
     * @param argument Gets or sets the on-premises agent details.
     */
    @JvmName("egbqtguqjvfalnwo")
    public suspend fun agentDetails(argument: suspend SiteAgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteAgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentDetails = mapped
    }

    /**
     * @param value Gets or sets the Appliance Name.
     */
    @JvmName("rqpkxlhsggokxrcj")
    public suspend fun applianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applianceName = mapped
    }

    /**
     * @param value  Gets or sets the service principal identity details used by agent for  communication              to the service.
     */
    @JvmName("svhorpknwunwcioq")
    public suspend fun servicePrincipalIdentityDetails(`value`: SiteSpnPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param argument  Gets or sets the service principal identity details used by agent for  communication              to the service.
     */
    @JvmName("kjwbtayoodeqnhyj")
    public suspend
    fun servicePrincipalIdentityDetails(argument: suspend SiteSpnPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteSpnPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalIdentityDetails = mapped
    }

    internal fun build(): SiteAppliancePropertiesArgs = SiteAppliancePropertiesArgs(
        agentDetails = agentDetails,
        applianceName = applianceName,
        servicePrincipalIdentityDetails = servicePrincipalIdentityDetails,
    )
}
