@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.SitePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for site properties.
 * @property agentDetails On-premises agent details.
 * @property applianceName Appliance Name.
 * @property discoverySolutionId ARM ID of migration hub solution for SDS.
 * @property servicePrincipalIdentityDetails Service principal identity details used by agent for communication to the service.
 */
public data class SitePropertiesArgs(
    public val agentDetails: Output<SiteAgentPropertiesArgs>? = null,
    public val applianceName: Output<String>? = null,
    public val discoverySolutionId: Output<String>? = null,
    public val servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.SitePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.SitePropertiesArgs =
        com.pulumi.azurenative.offazure.inputs.SitePropertiesArgs.builder()
            .agentDetails(agentDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .applianceName(applianceName?.applyValue({ args0 -> args0 }))
            .discoverySolutionId(discoverySolutionId?.applyValue({ args0 -> args0 }))
            .servicePrincipalIdentityDetails(
                servicePrincipalIdentityDetails?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [SitePropertiesArgs].
 */
@PulumiTagMarker
public class SitePropertiesArgsBuilder internal constructor() {
    private var agentDetails: Output<SiteAgentPropertiesArgs>? = null

    private var applianceName: Output<String>? = null

    private var discoverySolutionId: Output<String>? = null

    private var servicePrincipalIdentityDetails: Output<SiteSpnPropertiesArgs>? = null

    /**
     * @param value On-premises agent details.
     */
    @JvmName("ntjxnlhexxuelcsj")
    public suspend fun agentDetails(`value`: Output<SiteAgentPropertiesArgs>) {
        this.agentDetails = value
    }

    /**
     * @param value Appliance Name.
     */
    @JvmName("ehlxeubklxeffgun")
    public suspend fun applianceName(`value`: Output<String>) {
        this.applianceName = value
    }

    /**
     * @param value ARM ID of migration hub solution for SDS.
     */
    @JvmName("jbhbxasxpfrfmans")
    public suspend fun discoverySolutionId(`value`: Output<String>) {
        this.discoverySolutionId = value
    }

    /**
     * @param value Service principal identity details used by agent for communication to the service.
     */
    @JvmName("dgcwaqmjrqumebrf")
    public suspend fun servicePrincipalIdentityDetails(`value`: Output<SiteSpnPropertiesArgs>) {
        this.servicePrincipalIdentityDetails = value
    }

    /**
     * @param value On-premises agent details.
     */
    @JvmName("yfljgrbxvmypfrku")
    public suspend fun agentDetails(`value`: SiteAgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentDetails = mapped
    }

    /**
     * @param argument On-premises agent details.
     */
    @JvmName("lrlkxhujnmrrcypl")
    public suspend fun agentDetails(argument: suspend SiteAgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteAgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentDetails = mapped
    }

    /**
     * @param value Appliance Name.
     */
    @JvmName("svgkgvkgfjqbnfdi")
    public suspend fun applianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applianceName = mapped
    }

    /**
     * @param value ARM ID of migration hub solution for SDS.
     */
    @JvmName("bkwicmxcakeoojuk")
    public suspend fun discoverySolutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySolutionId = mapped
    }

    /**
     * @param value Service principal identity details used by agent for communication to the service.
     */
    @JvmName("sufgbcrahxdqyxnm")
    public suspend fun servicePrincipalIdentityDetails(`value`: SiteSpnPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalIdentityDetails = mapped
    }

    /**
     * @param argument Service principal identity details used by agent for communication to the service.
     */
    @JvmName("eengjlsvbqurwpym")
    public suspend
    fun servicePrincipalIdentityDetails(argument: suspend SiteSpnPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SiteSpnPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.servicePrincipalIdentityDetails = mapped
    }

    internal fun build(): SitePropertiesArgs = SitePropertiesArgs(
        agentDetails = agentDetails,
        applianceName = applianceName,
        discoverySolutionId = discoverySolutionId,
        servicePrincipalIdentityDetails = servicePrincipalIdentityDetails,
    )
}
