@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A SQL discovery site data source resource.
 * @property discoverySiteId Gets or sets the discovery site Id.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState provisioning state enum
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSqlDiscoverySiteDataSourceControllerResult(
    public val discoverySiteId: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetSqlDiscoverySiteDataSourceControllerResult):
            GetSqlDiscoverySiteDataSourceControllerResult =
            GetSqlDiscoverySiteDataSourceControllerResult(
                discoverySiteId = javaType.discoverySiteId().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                name = javaType.name(),
                provisioningState = javaType.provisioningState(),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
