@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class for site properties.
 * @property agentDetails On-premises agent details.
 * @property applianceName Appliance Name.
 * @property discoverySolutionId ARM ID of migration hub solution for SDS.
 * @property serviceEndpoint Service endpoint.
 * @property servicePrincipalIdentityDetails Service principal identity details used by agent for communication to the service.
 */
public data class SitePropertiesResponse(
    public val agentDetails: SiteAgentPropertiesResponse? = null,
    public val applianceName: String? = null,
    public val discoverySolutionId: String? = null,
    public val serviceEndpoint: String,
    public val servicePrincipalIdentityDetails: SiteSpnPropertiesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.SitePropertiesResponse):
            SitePropertiesResponse = SitePropertiesResponse(
            agentDetails = javaType.agentDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SiteAgentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            applianceName = javaType.applianceName().map({ args0 -> args0 }).orElse(null),
            discoverySolutionId = javaType.discoverySolutionId().map({ args0 -> args0 }).orElse(null),
            serviceEndpoint = javaType.serviceEndpoint(),
            servicePrincipalIdentityDetails = javaType.servicePrincipalIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.SiteSpnPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
