@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin

import com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs.builder
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootserversPropertiesArgs
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootserversPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The springbootservers envelope resource definition.
 * Azure REST API version: 2023-01-01-preview.
 * ## Example Usage
 * ### springbootservers_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootserver = new AzureNative.OffAzureSpringBoot.Springbootserver("springbootserver", new()
 *     {
 *         Properties = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootserversPropertiesArgs
 *         {
 *             Errors = new() { },
 *             FqdnAndIpAddressList = new() { },
 *             MachineArmId = "fvfkiapbqsprnbzczdfmuryknrna",
 *             Port = 10,
 *             Server = "thhuxocfyqpeluqcgnypi",
 *             SpringBootApps = 17,
 *             TotalApps = 5,
 *         },
 *         ResourceGroupName = "rgspringbootservers",
 *         SiteName = "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj",
 *         SpringbootserversName = "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootserver(ctx, "springbootserver", &offazurespringboot.SpringbootserverArgs{
 * 			Properties: &offazurespringboot.SpringbootserversPropertiesArgs{
 * 				Errors:               offazurespringboot.ErrorArray{},
 * 				FqdnAndIpAddressList: pulumi.StringArray{},
 * 				MachineArmId:         pulumi.String("fvfkiapbqsprnbzczdfmuryknrna"),
 * 				Port:                 pulumi.Int(10),
 * 				Server:               pulumi.String("thhuxocfyqpeluqcgnypi"),
 * 				SpringBootApps:       pulumi.Int(17),
 * 				TotalApps:            pulumi.Int(5),
 * 			},
 * 			ResourceGroupName:     pulumi.String("rgspringbootservers"),
 * 			SiteName:              pulumi.String("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj"),
 * 			SpringbootserversName: pulumi.String("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootserver;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs;
 * import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootserversPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootserver = new Springbootserver("springbootserver", SpringbootserverArgs.builder()
 *             .properties(SpringbootserversPropertiesArgs.builder()
 *                 .errors()
 *                 .fqdnAndIpAddressList()
 *                 .machineArmId("fvfkiapbqsprnbzczdfmuryknrna")
 *                 .port(10)
 *                 .server("thhuxocfyqpeluqcgnypi")
 *                 .springBootApps(17)
 *                 .totalApps(5)
 *                 .build())
 *             .resourceGroupName("rgspringbootservers")
 *             .siteName("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj")
 *             .springbootserversName("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn")
 *             .build());
 *     }
 * }
 * ```
 * ### springbootservers_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootserver = new AzureNative.OffAzureSpringBoot.Springbootserver("springbootserver", new()
 *     {
 *         ResourceGroupName = "rgspringbootservers",
 *         SiteName = "hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj",
 *         SpringbootserversName = "zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootserver(ctx, "springbootserver", &offazurespringboot.SpringbootserverArgs{
 * 			ResourceGroupName:     pulumi.String("rgspringbootservers"),
 * 			SiteName:              pulumi.String("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj"),
 * 			SpringbootserversName: pulumi.String("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootserver;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootserver = new Springbootserver("springbootserver", SpringbootserverArgs.builder()
 *             .resourceGroupName("rgspringbootservers")
 *             .siteName("hlkrzldhyobavtabgpubtjbhlslnjmsvkthwcfboriwyxndacjypzbj")
 *             .springbootserversName("zkarbqnwnxeozvjrkpdqmgnwedwgtwcmmyqwaijkn")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazurespringboot:Springbootserver licrobomiqalwnrti /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootservers/{springbootserversName}
 * ```
 * @property properties The springbootservers resource definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName The springbootsites name.
 * @property springbootserversName The springbootservers name.
 * @property tags Resource tags
 */
public data class SpringbootserverArgs(
    public val properties: Output<SpringbootserversPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val siteName: Output<String>? = null,
    public val springbootserversName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs> {
    override fun toJava(): com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs =
        com.pulumi.azurenative.offazurespringboot.SpringbootserverArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .siteName(siteName?.applyValue({ args0 -> args0 }))
            .springbootserversName(springbootserversName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SpringbootserverArgs].
 */
@PulumiTagMarker
public class SpringbootserverArgsBuilder internal constructor() {
    private var properties: Output<SpringbootserversPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var siteName: Output<String>? = null

    private var springbootserversName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The springbootservers resource definition.
     */
    @JvmName("tsshkfgwfcjjgsuc")
    public suspend fun properties(`value`: Output<SpringbootserversPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jvpxqghumdbgxlmc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("nkbxklsxlgtxbecc")
    public suspend fun siteName(`value`: Output<String>) {
        this.siteName = value
    }

    /**
     * @param value The springbootservers name.
     */
    @JvmName("rpsvflbfcsimapcq")
    public suspend fun springbootserversName(`value`: Output<String>) {
        this.springbootserversName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("xxukebujfbbkydaq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The springbootservers resource definition.
     */
    @JvmName("jmgcejbprdesksfe")
    public suspend fun properties(`value`: SpringbootserversPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The springbootservers resource definition.
     */
    @JvmName("thnhvepjchujdmuv")
    public suspend
    fun properties(argument: suspend SpringbootserversPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SpringbootserversPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("syckyidxrdnvoseb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("kmwexqdmyaqodyqj")
    public suspend fun siteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.siteName = mapped
    }

    /**
     * @param value The springbootservers name.
     */
    @JvmName("hqrswrtprmucybcq")
    public suspend fun springbootserversName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.springbootserversName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jnxoaagtlajrjgvi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("eqtnsokutpwscrtx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SpringbootserverArgs = SpringbootserverArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        siteName = siteName,
        springbootserversName = springbootserversName,
        tags = tags,
    )
}
