@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesApplicationConfigurationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key The application config file name.
 * @property value The application config file content, only contains config keys.
 */
public data class SpringbootappsPropertiesApplicationConfigurationsArgs(
    public val key: Output<String>,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesApplicationConfigurationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesApplicationConfigurationsArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesApplicationConfigurationsArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpringbootappsPropertiesApplicationConfigurationsArgs].
 */
@PulumiTagMarker
public class SpringbootappsPropertiesApplicationConfigurationsArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The application config file name.
     */
    @JvmName("xhstnwaytnexekhv")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The application config file content, only contains config keys.
     */
    @JvmName("dafyjxaicnanfjhh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The application config file name.
     */
    @JvmName("yupgfolednfiobkt")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The application config file content, only contains config keys.
     */
    @JvmName("pqpugkybfvsswigy")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SpringbootappsPropertiesApplicationConfigurationsArgs =
        SpringbootappsPropertiesApplicationConfigurationsArgs(
            key = key ?: throw PulumiNullFieldException("key"),
            `value` = `value`,
        )
}
