@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesInstancesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceCount The instance count of this app instance
 * @property jvmMemoryInMB The jvm heap memory allocated of this app instance
 * @property machineArmId The machine ARM resource Id of this app instance
 */
public data class SpringbootappsPropertiesInstancesArgs(
    public val instanceCount: Output<Int>? = null,
    public val jvmMemoryInMB: Output<Int>? = null,
    public val machineArmId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesInstancesArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesInstancesArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootappsPropertiesInstancesArgs.builder()
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .jvmMemoryInMB(jvmMemoryInMB?.applyValue({ args0 -> args0 }))
            .machineArmId(machineArmId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpringbootappsPropertiesInstancesArgs].
 */
@PulumiTagMarker
public class SpringbootappsPropertiesInstancesArgsBuilder internal constructor() {
    private var instanceCount: Output<Int>? = null

    private var jvmMemoryInMB: Output<Int>? = null

    private var machineArmId: Output<String>? = null

    /**
     * @param value The instance count of this app instance
     */
    @JvmName("kjosxorsfublfagf")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The jvm heap memory allocated of this app instance
     */
    @JvmName("jrcnldglwghljxhy")
    public suspend fun jvmMemoryInMB(`value`: Output<Int>) {
        this.jvmMemoryInMB = value
    }

    /**
     * @param value The machine ARM resource Id of this app instance
     */
    @JvmName("ylmnneeutcwnojoi")
    public suspend fun machineArmId(`value`: Output<String>) {
        this.machineArmId = value
    }

    /**
     * @param value The instance count of this app instance
     */
    @JvmName("ejceyacjqprbgnrn")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The jvm heap memory allocated of this app instance
     */
    @JvmName("pkpdykrycgchkdgo")
    public suspend fun jvmMemoryInMB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jvmMemoryInMB = mapped
    }

    /**
     * @param value The machine ARM resource Id of this app instance
     */
    @JvmName("jtmgaywwhnjxyyax")
    public suspend fun machineArmId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machineArmId = mapped
    }

    internal fun build(): SpringbootappsPropertiesInstancesArgs =
        SpringbootappsPropertiesInstancesArgs(
            instanceCount = instanceCount,
            jvmMemoryInMB = jvmMemoryInMB,
            machineArmId = machineArmId ?: throw PulumiNullFieldException("machineArmId"),
        )
}
