@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootserversPropertiesArgs.builder
import com.pulumi.azurenative.offazurespringboot.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The springbootservers resource definition.
 * @property errors The list of errors.
 * @property fqdnAndIpAddressList The alternative FQDN or IP addresses to discover for this server
 * @property machineArmId The machine Id from ARM
 * @property port Target server port for remote login
 * @property provisioningState The resource provisioning state.
 * @property server Server is the target server name or ip address to discover of SpringBootServer.
 * @property springBootApps The total number of spring boot apps been discovered
 * @property totalApps The total number of apps been discovered
 */
public data class SpringbootserversPropertiesArgs(
    public val errors: Output<List<ErrorArgs>>? = null,
    public val fqdnAndIpAddressList: Output<List<String>>? = null,
    public val machineArmId: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val server: Output<String>,
    public val springBootApps: Output<Int>? = null,
    public val totalApps: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.SpringbootserversPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootserversPropertiesArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootserversPropertiesArgs.builder()
            .errors(errors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .fqdnAndIpAddressList(fqdnAndIpAddressList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .machineArmId(machineArmId?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .server(server.applyValue({ args0 -> args0 }))
            .springBootApps(springBootApps?.applyValue({ args0 -> args0 }))
            .totalApps(totalApps?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpringbootserversPropertiesArgs].
 */
@PulumiTagMarker
public class SpringbootserversPropertiesArgsBuilder internal constructor() {
    private var errors: Output<List<ErrorArgs>>? = null

    private var fqdnAndIpAddressList: Output<List<String>>? = null

    private var machineArmId: Output<String>? = null

    private var port: Output<Int>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var server: Output<String>? = null

    private var springBootApps: Output<Int>? = null

    private var totalApps: Output<Int>? = null

    /**
     * @param value The list of errors.
     */
    @JvmName("raowwjtpdgpejxmy")
    public suspend fun errors(`value`: Output<List<ErrorArgs>>) {
        this.errors = value
    }

    @JvmName("kylmgstjcarijopa")
    public suspend fun errors(vararg values: Output<ErrorArgs>) {
        this.errors = Output.all(values.asList())
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("mvylynfsdbdsmwuq")
    public suspend fun errors(values: List<Output<ErrorArgs>>) {
        this.errors = Output.all(values)
    }

    /**
     * @param value The alternative FQDN or IP addresses to discover for this server
     */
    @JvmName("okfvcwwarjomwmvs")
    public suspend fun fqdnAndIpAddressList(`value`: Output<List<String>>) {
        this.fqdnAndIpAddressList = value
    }

    @JvmName("lxwiypwqlibcmfmh")
    public suspend fun fqdnAndIpAddressList(vararg values: Output<String>) {
        this.fqdnAndIpAddressList = Output.all(values.asList())
    }

    /**
     * @param values The alternative FQDN or IP addresses to discover for this server
     */
    @JvmName("jblxkinbmkpydmuc")
    public suspend fun fqdnAndIpAddressList(values: List<Output<String>>) {
        this.fqdnAndIpAddressList = Output.all(values)
    }

    /**
     * @param value The machine Id from ARM
     */
    @JvmName("ptbhcladlbxsgljv")
    public suspend fun machineArmId(`value`: Output<String>) {
        this.machineArmId = value
    }

    /**
     * @param value Target server port for remote login
     */
    @JvmName("sascfpdqtmnwpcdx")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("cphwqpwcxoofvnla")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Server is the target server name or ip address to discover of SpringBootServer.
     */
    @JvmName("sxrntiwauqueawja")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The total number of spring boot apps been discovered
     */
    @JvmName("eatkvyhgkunughqc")
    public suspend fun springBootApps(`value`: Output<Int>) {
        this.springBootApps = value
    }

    /**
     * @param value The total number of apps been discovered
     */
    @JvmName("hpxbouyjabdatkwh")
    public suspend fun totalApps(`value`: Output<Int>) {
        this.totalApps = value
    }

    /**
     * @param value The list of errors.
     */
    @JvmName("anddxquvdmgqwlke")
    public suspend fun errors(`value`: List<ErrorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("jvactjcswyoqback")
    public suspend fun errors(argument: List<suspend ErrorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("ioalxbukuwsydaog")
    public suspend fun errors(vararg argument: suspend ErrorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ErrorArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("sbtrxatybakgkmrr")
    public suspend fun errors(argument: suspend ErrorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ErrorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("lkovilmqduttelko")
    public suspend fun errors(vararg values: ErrorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param value The alternative FQDN or IP addresses to discover for this server
     */
    @JvmName("unjtxluiasnyicyd")
    public suspend fun fqdnAndIpAddressList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnAndIpAddressList = mapped
    }

    /**
     * @param values The alternative FQDN or IP addresses to discover for this server
     */
    @JvmName("ixprcqemvsjkoskd")
    public suspend fun fqdnAndIpAddressList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnAndIpAddressList = mapped
    }

    /**
     * @param value The machine Id from ARM
     */
    @JvmName("dcopiqttfxhvoork")
    public suspend fun machineArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineArmId = mapped
    }

    /**
     * @param value Target server port for remote login
     */
    @JvmName("khceptfjkvkftmnx")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("fvrfopnpqyspdqkd")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("wghddukndhaitsxe")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("osipgmkayhhtkfsx")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Server is the target server name or ip address to discover of SpringBootServer.
     */
    @JvmName("bpvgtfaaqdtdvmml")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The total number of spring boot apps been discovered
     */
    @JvmName("skfnvmwxocppwfwx")
    public suspend fun springBootApps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.springBootApps = mapped
    }

    /**
     * @param value The total number of apps been discovered
     */
    @JvmName("mberpupvbynhevfs")
    public suspend fun totalApps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalApps = mapped
    }

    internal fun build(): SpringbootserversPropertiesArgs = SpringbootserversPropertiesArgs(
        errors = errors,
        fqdnAndIpAddressList = fqdnAndIpAddressList,
        machineArmId = machineArmId,
        port = port,
        provisioningState = provisioningState,
        server = server ?: throw PulumiNullFieldException("server"),
        springBootApps = springBootApps,
        totalApps = totalApps,
    )
}
