@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesPropertiesArgs.builder
import com.pulumi.azurenative.offazurespringboot.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The springbootsites resource definition.
 * @property masterSiteId The master site ID from Azure Migrate.
 * @property migrateProjectId The migrate project ID from Azure Migrate.
 * @property provisioningState The resource provisioning state.
 */
public data class SpringbootsitesPropertiesArgs(
    public val masterSiteId: Output<String>? = null,
    public val migrateProjectId: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesPropertiesArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesPropertiesArgs.builder()
            .masterSiteId(masterSiteId?.applyValue({ args0 -> args0 }))
            .migrateProjectId(migrateProjectId?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [SpringbootsitesPropertiesArgs].
 */
@PulumiTagMarker
public class SpringbootsitesPropertiesArgsBuilder internal constructor() {
    private var masterSiteId: Output<String>? = null

    private var migrateProjectId: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    /**
     * @param value The master site ID from Azure Migrate.
     */
    @JvmName("qaunivhievobxyug")
    public suspend fun masterSiteId(`value`: Output<String>) {
        this.masterSiteId = value
    }

    /**
     * @param value The migrate project ID from Azure Migrate.
     */
    @JvmName("fcitqrxqnprtggnp")
    public suspend fun migrateProjectId(`value`: Output<String>) {
        this.migrateProjectId = value
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("mntufosrlpahruma")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The master site ID from Azure Migrate.
     */
    @JvmName("bngjvmturbrblxfg")
    public suspend fun masterSiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterSiteId = mapped
    }

    /**
     * @param value The migrate project ID from Azure Migrate.
     */
    @JvmName("uyqraskddgbkdlxo")
    public suspend fun migrateProjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectId = mapped
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("ydhcqpnyveuvltwq")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("sgkpnmkpsgiykods")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The resource provisioning state.
     */
    @JvmName("gpyoqvjyvgatsfka")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): SpringbootsitesPropertiesArgs = SpringbootsitesPropertiesArgs(
        masterSiteId = masterSiteId,
        migrateProjectId = migrateProjectId,
        provisioningState = provisioningState,
    )
}
