@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instanceCount The instance count of this app instance
 * @property jvmMemoryInMB The jvm heap memory allocated of this app instance
 * @property machineArmId The machine ARM resource Id of this app instance
 */
public data class SpringbootappsPropertiesResponseInstances(
    public val instanceCount: Int? = null,
    public val jvmMemoryInMB: Int? = null,
    public val machineArmId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazurespringboot.outputs.SpringbootappsPropertiesResponseInstances):
            SpringbootappsPropertiesResponseInstances = SpringbootappsPropertiesResponseInstances(
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            jvmMemoryInMB = javaType.jvmMemoryInMB().map({ args0 -> args0 }).orElse(null),
            machineArmId = javaType.machineArmId(),
        )
    }
}
