@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin.inputs

import com.pulumi.azurenative.openenergyplatform.inputs.ListEnergyServicePartitionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The resource name.
 */
public data class ListEnergyServicePartitionsPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.openenergyplatform.inputs.ListEnergyServicePartitionsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.openenergyplatform.inputs.ListEnergyServicePartitionsPlainArgs =
        com.pulumi.azurenative.openenergyplatform.inputs.ListEnergyServicePartitionsPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListEnergyServicePartitionsPlainArgs].
 */
@PulumiTagMarker
public class ListEnergyServicePartitionsPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qjqnyftqjrwxrjnl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name.
     */
    @JvmName("upekgrrxxeuxjamu")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): ListEnergyServicePartitionsPlainArgs = ListEnergyServicePartitionsPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
