@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LinkedService].
 */
@PulumiTagMarker
public class LinkedServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkedServiceArgs = LinkedServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkedServiceArgsBuilder.() -> Unit) {
        val builder = LinkedServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LinkedService {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.LinkedService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkedService(builtJavaResource)
    }
}

/**
 * The top level Linked service resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * Other available API versions: 2015-11-01-preview.
 * ## Example Usage
 * ### LinkedServicesCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.OperationalInsights.LinkedService("linkedService", new()
 *     {
 *         LinkedServiceName = "Cluster",
 *         ResourceGroupName = "mms-eus",
 *         WorkspaceName = "TestLinkWS",
 *         WriteAccessResourceId = "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/clusters/testcluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewLinkedService(ctx, "linkedService", &operationalinsights.LinkedServiceArgs{
 * 			LinkedServiceName:     pulumi.String("Cluster"),
 * 			ResourceGroupName:     pulumi.String("mms-eus"),
 * 			WorkspaceName:         pulumi.String("TestLinkWS"),
 * 			WriteAccessResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/clusters/testcluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.LinkedService;
 * import com.pulumi.azurenative.operationalinsights.LinkedServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .linkedServiceName("Cluster")
 *             .resourceGroupName("mms-eus")
 *             .workspaceName("TestLinkWS")
 *             .writeAccessResourceId("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.OperationalInsights/clusters/testcluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:LinkedService TestLinkWS/Cluster /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedServices/{linkedServiceName}
 * ```
 */
public class LinkedService internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.LinkedService,
) : KotlinCustomResource(javaResource, LinkedServiceMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the linked service.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require read access
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require write access
     */
    public val writeAccessResourceId: Output<String>?
        get() = javaResource.writeAccessResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object LinkedServiceMapper : ResourceMapper<LinkedService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.LinkedService::class == javaResource::class

    override fun map(javaResource: Resource): LinkedService = LinkedService(
        javaResource as
            com.pulumi.azurenative.operationalinsights.LinkedService,
    )
}

/**
 * @see [LinkedService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkedService].
 */
public suspend fun linkedService(
    name: String,
    block: suspend LinkedServiceResourceBuilder.() -> Unit,
): LinkedService {
    val builder = LinkedServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkedService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkedService(name: String): LinkedService {
    val builder = LinkedServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
