@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LinkedStorageAccount].
 */
@PulumiTagMarker
public class LinkedStorageAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkedStorageAccountArgs = LinkedStorageAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkedStorageAccountArgsBuilder.() -> Unit) {
        val builder = LinkedStorageAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LinkedStorageAccount {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.LinkedStorageAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkedStorageAccount(builtJavaResource)
    }
}

/**
 * Linked storage accounts top level resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### LinkedStorageAccountsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedStorageAccount = new AzureNative.OperationalInsights.LinkedStorageAccount("linkedStorageAccount", new()
 *     {
 *         DataSourceType = "CustomLogs",
 *         ResourceGroupName = "mms-eus",
 *         StorageAccountIds = new[]
 *         {
 *             "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA",
 *             "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB",
 *         },
 *         WorkspaceName = "testLinkStorageAccountsWS",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewLinkedStorageAccount(ctx, "linkedStorageAccount", &operationalinsights.LinkedStorageAccountArgs{
 * 			DataSourceType:    pulumi.String("CustomLogs"),
 * 			ResourceGroupName: pulumi.String("mms-eus"),
 * 			StorageAccountIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
 * 				pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB"),
 * 			},
 * 			WorkspaceName: pulumi.String("testLinkStorageAccountsWS"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.LinkedStorageAccount;
 * import com.pulumi.azurenative.operationalinsights.LinkedStorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedStorageAccount = new LinkedStorageAccount("linkedStorageAccount", LinkedStorageAccountArgs.builder()
 *             .dataSourceType("CustomLogs")
 *             .resourceGroupName("mms-eus")
 *             .storageAccountIds(
 *                 "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA",
 *                 "/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB")
 *             .workspaceName("testLinkStorageAccountsWS")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:LinkedStorageAccount CustomLogs /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/linkedStorageAccounts/{dataSourceType}
 * ```
 */
public class LinkedStorageAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.LinkedStorageAccount,
) : KotlinCustomResource(javaResource, LinkedStorageAccountMapper) {
    /**
     * Linked storage accounts type.
     */
    public val dataSourceType: Output<String>
        get() = javaResource.dataSourceType().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Linked storage accounts resources ids.
     */
    public val storageAccountIds: Output<List<String>>?
        get() = javaResource.storageAccountIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkedStorageAccountMapper : ResourceMapper<LinkedStorageAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.LinkedStorageAccount::class == javaResource::class

    override fun map(javaResource: Resource): LinkedStorageAccount = LinkedStorageAccount(
        javaResource
            as com.pulumi.azurenative.operationalinsights.LinkedStorageAccount,
    )
}

/**
 * @see [LinkedStorageAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkedStorageAccount].
 */
public suspend fun linkedStorageAccount(
    name: String,
    block: suspend LinkedStorageAccountResourceBuilder.() -> Unit,
): LinkedStorageAccount {
    val builder = LinkedStorageAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkedStorageAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkedStorageAccount(name: String): LinkedStorageAccount {
    val builder = LinkedStorageAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
