@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.MachineGroupArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.MachineGroupType
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.MachineReferenceWithHintsArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.MachineReferenceWithHintsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A user-defined logical grouping of machines.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### SMMachineGroupsUpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineGroup = new AzureNative.OperationalInsights.MachineGroup("machineGroup", new()
 *     {
 *         Count = 1,
 *         DisplayName = "Foo",
 *         Kind = "machineGroup",
 *         MachineGroupName = "ccfbf4bf-dc08-4371-9e9b-00a8d875d45a",
 *         Machines = new[]
 *         {
 *             new AzureNative.OperationalInsights.Inputs.MachineReferenceWithHintsArgs
 *             {
 *                 Id = "/subscriptions/63BE4E24-FDF0-4E9C-9342-6A5D5A359722/resourceGroups/rg-sm/providers/Microsoft.OperationalInsights/workspaces/D6F79F14-E563-469B-84B5-9286D2803B2F/machines/m-0fe4b501-7ac9-41d7-a4e1-1591a0789519",
 *                 Kind = "ref:machinewithhints",
 *             },
 *         },
 *         ResourceGroupName = "rg-sm",
 *         WorkspaceName = "D6F79F14-E563-469B-84B5-9286D2803B2F",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := operationalinsights.NewMachineGroup(ctx, "machineGroup", &operationalinsights.MachineGroupArgs{
 * Count: pulumi.Int(1),
 * DisplayName: pulumi.String("Foo"),
 * Kind: pulumi.String("machineGroup"),
 * MachineGroupName: pulumi.String("ccfbf4bf-dc08-4371-9e9b-00a8d875d45a"),
 * Machines: operationalinsights.MachineReferenceWithHintsArray{
 * interface{}{
 * Id: pulumi.String("/subscriptions/63BE4E24-FDF0-4E9C-9342-6A5D5A359722/resourceGroups/rg-sm/providers/Microsoft.OperationalInsights/workspaces/D6F79F14-E563-469B-84B5-9286D2803B2F/machines/m-0fe4b501-7ac9-41d7-a4e1-1591a0789519"),
 * Kind: pulumi.String("ref:machinewithhints"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rg-sm"),
 * WorkspaceName: pulumi.String("D6F79F14-E563-469B-84B5-9286D2803B2F"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.MachineGroup;
 * import com.pulumi.azurenative.operationalinsights.MachineGroupArgs;
 * import com.pulumi.azurenative.operationalinsights.inputs.MachineReferenceWithHintsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineGroup = new MachineGroup("machineGroup", MachineGroupArgs.builder()
 *             .count(1)
 *             .displayName("Foo")
 *             .kind("machineGroup")
 *             .machineGroupName("ccfbf4bf-dc08-4371-9e9b-00a8d875d45a")
 *             .machines(MachineReferenceWithHintsArgs.builder()
 *                 .id("/subscriptions/63BE4E24-FDF0-4E9C-9342-6A5D5A359722/resourceGroups/rg-sm/providers/Microsoft.OperationalInsights/workspaces/D6F79F14-E563-469B-84B5-9286D2803B2F/machines/m-0fe4b501-7ac9-41d7-a4e1-1591a0789519")
 *                 .kind("ref:machinewithhints")
 *                 .build())
 *             .resourceGroupName("rg-sm")
 *             .workspaceName("D6F79F14-E563-469B-84B5-9286D2803B2F")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:MachineGroup ccfbf4bf-dc08-4371-9e9b-00a8d875d45a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machineGroups/{machineGroupName}
 * ```
 * @property count Count of machines in this group. The value of count may be bigger than the number of machines in case of the group has been truncated due to exceeding the max number of machines a group can handle.
 * @property displayName User defined name for the group
 * @property groupType Type of the machine group
 * @property kind Additional resource type qualifier.
 * Expected value is 'machineGroup'.
 * @property machineGroupName Machine Group resource name.
 * @property machines References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
 * @property resourceGroupName Resource group name within the specified subscriptionId.
 * @property workspaceName OMS workspace containing the resources of interest.
 */
public data class MachineGroupArgs(
    public val count: Output<Int>? = null,
    public val displayName: Output<String>? = null,
    public val groupType: Output<Either<String, MachineGroupType>>? = null,
    public val kind: Output<String>? = null,
    public val machineGroupName: Output<String>? = null,
    public val machines: Output<List<MachineReferenceWithHintsArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.MachineGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.MachineGroupArgs =
        com.pulumi.azurenative.operationalinsights.MachineGroupArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .groupType(
                groupType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .machineGroupName(machineGroupName?.applyValue({ args0 -> args0 }))
            .machines(
                machines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MachineGroupArgs].
 */
@PulumiTagMarker
public class MachineGroupArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var displayName: Output<String>? = null

    private var groupType: Output<Either<String, MachineGroupType>>? = null

    private var kind: Output<String>? = null

    private var machineGroupName: Output<String>? = null

    private var machines: Output<List<MachineReferenceWithHintsArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Count of machines in this group. The value of count may be bigger than the number of machines in case of the group has been truncated due to exceeding the max number of machines a group can handle.
     */
    @JvmName("vnlkbwbbsboggmax")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value User defined name for the group
     */
    @JvmName("wbvildpivodkpubu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Type of the machine group
     */
    @JvmName("nkujubeagbuyjsjl")
    public suspend fun groupType(`value`: Output<Either<String, MachineGroupType>>) {
        this.groupType = value
    }

    /**
     * @param value Additional resource type qualifier.
     * Expected value is 'machineGroup'.
     */
    @JvmName("bgrmvpatvvvpuway")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Machine Group resource name.
     */
    @JvmName("clurxhrlhrshtvie")
    public suspend fun machineGroupName(`value`: Output<String>) {
        this.machineGroupName = value
    }

    /**
     * @param value References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    @JvmName("llccsknxeaxxness")
    public suspend fun machines(`value`: Output<List<MachineReferenceWithHintsArgs>>) {
        this.machines = value
    }

    @JvmName("vborcbekrwcegujv")
    public suspend fun machines(vararg values: Output<MachineReferenceWithHintsArgs>) {
        this.machines = Output.all(values.asList())
    }

    /**
     * @param values References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    @JvmName("cixtoiefturkyhbq")
    public suspend fun machines(values: List<Output<MachineReferenceWithHintsArgs>>) {
        this.machines = Output.all(values)
    }

    /**
     * @param value Resource group name within the specified subscriptionId.
     */
    @JvmName("eqghywohdbarmcck")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value OMS workspace containing the resources of interest.
     */
    @JvmName("fwkupbvtldckejrb")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Count of machines in this group. The value of count may be bigger than the number of machines in case of the group has been truncated due to exceeding the max number of machines a group can handle.
     */
    @JvmName("ciprmvenlwgunqtq")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value User defined name for the group
     */
    @JvmName("xvyhgpaqhpfipnac")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Type of the machine group
     */
    @JvmName("fiepnutkrwcstcyy")
    public suspend fun groupType(`value`: Either<String, MachineGroupType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Type of the machine group
     */
    @JvmName("bkyagykiuxkfecxh")
    public fun groupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MachineGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Type of the machine group
     */
    @JvmName("suffrvormctpgocs")
    public fun groupType(`value`: MachineGroupType) {
        val toBeMapped = Either.ofRight<String, MachineGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Additional resource type qualifier.
     * Expected value is 'machineGroup'.
     */
    @JvmName("qambisykfevgfhso")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Machine Group resource name.
     */
    @JvmName("ktosbkhoccgejclo")
    public suspend fun machineGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineGroupName = mapped
    }

    /**
     * @param value References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    @JvmName("gvuxwlhprptlggga")
    public suspend fun machines(`value`: List<MachineReferenceWithHintsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machines = mapped
    }

    /**
     * @param argument References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    @JvmName("kpnrgmrponokpewb")
    public suspend
    fun machines(argument: List<suspend MachineReferenceWithHintsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MachineReferenceWithHintsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.machines = mapped
    }

    /**
     * @param argument References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    @JvmName("lkmnhfynsoybshnd")
    public suspend fun machines(
        vararg
        argument: suspend MachineReferenceWithHintsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MachineReferenceWithHintsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.machines = mapped
    }

    /**
     * @param argument References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    @JvmName("sclyrpepvafdkwqk")
    public suspend fun machines(argument: suspend MachineReferenceWithHintsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MachineReferenceWithHintsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.machines = mapped
    }

    /**
     * @param values References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    @JvmName("gpruiqdoqijhhscg")
    public suspend fun machines(vararg values: MachineReferenceWithHintsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machines = mapped
    }

    /**
     * @param value Resource group name within the specified subscriptionId.
     */
    @JvmName("tmonqmrlheesxlwi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value OMS workspace containing the resources of interest.
     */
    @JvmName("plinbxwxccdvsjfo")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): MachineGroupArgs = MachineGroupArgs(
        count = count,
        displayName = displayName,
        groupType = groupType,
        kind = kind,
        machineGroupName = machineGroupName,
        machines = machines,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
