@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getClusterPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getDataExportPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getDataSourcePlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getLinkedServicePlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getLinkedStorageAccountPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getMachineGroupPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getQueryPackPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getQueryPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getSavedSearchPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getSharedKeysPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getStorageInsightConfigPlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getTablePlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getWorkspacePlain
import com.pulumi.azurenative.operationalinsights.OperationalinsightsFunctions.getWorkspaceSharedKeysPlain
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetDataExportPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetDataExportPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetDataSourcePlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetDataSourcePlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetLinkedServicePlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetLinkedServicePlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetLinkedStorageAccountPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetLinkedStorageAccountPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetMachineGroupPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetMachineGroupPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetQueryPackPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetQueryPackPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetQueryPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetQueryPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetSavedSearchPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetSavedSearchPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetSharedKeysPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetSharedKeysPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetStorageInsightConfigPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetStorageInsightConfigPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetTablePlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetTablePlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetWorkspaceSharedKeysPlainArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.GetWorkspaceSharedKeysPlainArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetDataExportResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetDataSourceResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetLinkedServiceResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetLinkedStorageAccountResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetMachineGroupResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetQueryPackResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetQueryResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetSavedSearchResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetSharedKeysResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetStorageInsightConfigResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetTableResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetWorkspaceResult
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetWorkspaceSharedKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetDataExportResult.Companion.toKotlin as getDataExportResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetDataSourceResult.Companion.toKotlin as getDataSourceResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetLinkedServiceResult.Companion.toKotlin as getLinkedServiceResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetLinkedStorageAccountResult.Companion.toKotlin as getLinkedStorageAccountResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetMachineGroupResult.Companion.toKotlin as getMachineGroupResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetQueryPackResult.Companion.toKotlin as getQueryPackResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetQueryResult.Companion.toKotlin as getQueryResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetSavedSearchResult.Companion.toKotlin as getSavedSearchResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetSharedKeysResult.Companion.toKotlin as getSharedKeysResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetStorageInsightConfigResult.Companion.toKotlin as getStorageInsightConfigResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetTableResult.Companion.toKotlin as getTableResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.GetWorkspaceSharedKeysResult.Companion.toKotlin as getWorkspaceSharedKeysResultToKotlin

public object OperationalinsightsFunctions {
    /**
     * Gets a Log Analytics cluster instance.
     * Azure REST API version: 2021-06-01.
     * Other available API versions: 2019-08-01-preview, 2020-08-01, 2022-10-01.
     * @param argument null
     * @return The top level Log Analytics cluster resource container.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName Name of the Log Analytics Cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The top level Log Analytics cluster resource container.
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return The top level Log Analytics cluster resource container.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data export instance.
     * Azure REST API version: 2020-08-01.
     * @param argument null
     * @return The top level data export resource container.
     */
    public suspend fun getDataExport(argument: GetDataExportPlainArgs): GetDataExportResult =
        getDataExportResultToKotlin(getDataExportPlain(argument.toJava()).await())

    /**
     * @see [getDataExport].
     * @param dataExportName The data export rule name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The top level data export resource container.
     */
    public suspend fun getDataExport(
        dataExportName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetDataExportResult {
        val argument = GetDataExportPlainArgs(
            dataExportName = dataExportName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getDataExportResultToKotlin(getDataExportPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataExport].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetDataExportPlainArgs].
     * @return The top level data export resource container.
     */
    public suspend fun getDataExport(argument: suspend GetDataExportPlainArgsBuilder.() -> Unit):
        GetDataExportResult {
        val builder = GetDataExportPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataExportResultToKotlin(getDataExportPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a datasource instance.
     * Azure REST API version: 2020-08-01.
     * Other available API versions: 2015-11-01-preview.
     * @param argument null
     * @return Datasources under OMS Workspace.
     */
    public suspend fun getDataSource(argument: GetDataSourcePlainArgs): GetDataSourceResult =
        getDataSourceResultToKotlin(getDataSourcePlain(argument.toJava()).await())

    /**
     * @see [getDataSource].
     * @param dataSourceName Name of the datasource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Datasources under OMS Workspace.
     */
    public suspend fun getDataSource(
        dataSourceName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetDataSourceResult {
        val argument = GetDataSourcePlainArgs(
            dataSourceName = dataSourceName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getDataSourceResultToKotlin(getDataSourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getDataSource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetDataSourcePlainArgs].
     * @return Datasources under OMS Workspace.
     */
    public suspend fun getDataSource(argument: suspend GetDataSourcePlainArgsBuilder.() -> Unit):
        GetDataSourceResult {
        val builder = GetDataSourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataSourceResultToKotlin(getDataSourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a linked service instance.
     * Azure REST API version: 2020-08-01.
     * Other available API versions: 2015-11-01-preview.
     * @param argument null
     * @return The top level Linked service resource container.
     */
    public suspend fun getLinkedService(argument: GetLinkedServicePlainArgs): GetLinkedServiceResult =
        getLinkedServiceResultToKotlin(getLinkedServicePlain(argument.toJava()).await())

    /**
     * @see [getLinkedService].
     * @param linkedServiceName Name of the linked service.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The top level Linked service resource container.
     */
    public suspend fun getLinkedService(
        linkedServiceName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetLinkedServiceResult {
        val argument = GetLinkedServicePlainArgs(
            linkedServiceName = linkedServiceName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getLinkedServiceResultToKotlin(getLinkedServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkedService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetLinkedServicePlainArgs].
     * @return The top level Linked service resource container.
     */
    public suspend
    fun getLinkedService(argument: suspend GetLinkedServicePlainArgsBuilder.() -> Unit):
        GetLinkedServiceResult {
        val builder = GetLinkedServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkedServiceResultToKotlin(getLinkedServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets all linked storage account of a specific data source type associated with the specified workspace.
     * Azure REST API version: 2020-08-01.
     * @param argument null
     * @return Linked storage accounts top level resource container.
     */
    public suspend fun getLinkedStorageAccount(argument: GetLinkedStorageAccountPlainArgs):
        GetLinkedStorageAccountResult =
        getLinkedStorageAccountResultToKotlin(getLinkedStorageAccountPlain(argument.toJava()).await())

    /**
     * @see [getLinkedStorageAccount].
     * @param dataSourceType Linked storage accounts type.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return Linked storage accounts top level resource container.
     */
    public suspend fun getLinkedStorageAccount(
        dataSourceType: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetLinkedStorageAccountResult {
        val argument = GetLinkedStorageAccountPlainArgs(
            dataSourceType = dataSourceType,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getLinkedStorageAccountResultToKotlin(getLinkedStorageAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkedStorageAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetLinkedStorageAccountPlainArgs].
     * @return Linked storage accounts top level resource container.
     */
    public suspend
    fun getLinkedStorageAccount(argument: suspend GetLinkedStorageAccountPlainArgsBuilder.() -> Unit):
        GetLinkedStorageAccountResult {
        val builder = GetLinkedStorageAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkedStorageAccountResultToKotlin(getLinkedStorageAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the specified machine group as it existed during the specified time interval.
     * Azure REST API version: 2015-11-01-preview.
     * @param argument null
     * @return A user-defined logical grouping of machines.
     */
    public suspend fun getMachineGroup(argument: GetMachineGroupPlainArgs): GetMachineGroupResult =
        getMachineGroupResultToKotlin(getMachineGroupPlain(argument.toJava()).await())

    /**
     * @see [getMachineGroup].
     * @param endTime UTC date and time specifying the end time of an interval. When not specified the service uses DateTime.UtcNow
     * @param machineGroupName Machine Group resource name.
     * @param resourceGroupName Resource group name within the specified subscriptionId.
     * @param startTime UTC date and time specifying the start time of an interval. When not specified the service uses DateTime.UtcNow - 10m
     * @param workspaceName OMS workspace containing the resources of interest.
     * @return A user-defined logical grouping of machines.
     */
    public suspend fun getMachineGroup(
        endTime: String? = null,
        machineGroupName: String,
        resourceGroupName: String,
        startTime: String? = null,
        workspaceName: String,
    ): GetMachineGroupResult {
        val argument = GetMachineGroupPlainArgs(
            endTime = endTime,
            machineGroupName = machineGroupName,
            resourceGroupName = resourceGroupName,
            startTime = startTime,
            workspaceName = workspaceName,
        )
        return getMachineGroupResultToKotlin(getMachineGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetMachineGroupPlainArgs].
     * @return A user-defined logical grouping of machines.
     */
    public suspend fun getMachineGroup(argument: suspend GetMachineGroupPlainArgsBuilder.() -> Unit):
        GetMachineGroupResult {
        val builder = GetMachineGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineGroupResultToKotlin(getMachineGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific Log Analytics Query defined within a Log Analytics QueryPack.
     * Azure REST API version: 2019-09-01.
     * Other available API versions: 2019-09-01-preview.
     * @param argument null
     * @return A Log Analytics QueryPack-Query definition.
     */
    public suspend fun getQuery(argument: GetQueryPlainArgs): GetQueryResult =
        getQueryResultToKotlin(getQueryPlain(argument.toJava()).await())

    /**
     * @see [getQuery].
     * @param id The id of a specific query defined in the Log Analytics QueryPack
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A Log Analytics QueryPack-Query definition.
     */
    public suspend fun getQuery(
        id: String,
        queryPackName: String,
        resourceGroupName: String,
    ): GetQueryResult {
        val argument = GetQueryPlainArgs(
            id = id,
            queryPackName = queryPackName,
            resourceGroupName = resourceGroupName,
        )
        return getQueryResultToKotlin(getQueryPlain(argument.toJava()).await())
    }

    /**
     * @see [getQuery].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetQueryPlainArgs].
     * @return A Log Analytics QueryPack-Query definition.
     */
    public suspend fun getQuery(argument: suspend GetQueryPlainArgsBuilder.() -> Unit):
        GetQueryResult {
        val builder = GetQueryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueryResultToKotlin(getQueryPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a Log Analytics QueryPack.
     * Azure REST API version: 2019-09-01.
     * Other available API versions: 2019-09-01-preview.
     * @param argument null
     * @return An Log Analytics QueryPack definition.
     */
    public suspend fun getQueryPack(argument: GetQueryPackPlainArgs): GetQueryPackResult =
        getQueryPackResultToKotlin(getQueryPackPlain(argument.toJava()).await())

    /**
     * @see [getQueryPack].
     * @param queryPackName The name of the Log Analytics QueryPack resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Log Analytics QueryPack definition.
     */
    public suspend fun getQueryPack(queryPackName: String, resourceGroupName: String):
        GetQueryPackResult {
        val argument = GetQueryPackPlainArgs(
            queryPackName = queryPackName,
            resourceGroupName = resourceGroupName,
        )
        return getQueryPackResultToKotlin(getQueryPackPlain(argument.toJava()).await())
    }

    /**
     * @see [getQueryPack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetQueryPackPlainArgs].
     * @return An Log Analytics QueryPack definition.
     */
    public suspend fun getQueryPack(argument: suspend GetQueryPackPlainArgsBuilder.() -> Unit):
        GetQueryPackResult {
        val builder = GetQueryPackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getQueryPackResultToKotlin(getQueryPackPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified saved search for a given workspace.
     * Azure REST API version: 2020-08-01.
     * Other available API versions: 2015-03-20.
     * @param argument null
     * @return Value object for saved search results.
     */
    public suspend fun getSavedSearch(argument: GetSavedSearchPlainArgs): GetSavedSearchResult =
        getSavedSearchResultToKotlin(getSavedSearchPlain(argument.toJava()).await())

    /**
     * @see [getSavedSearch].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param savedSearchId The id of the saved search.
     * @param workspaceName The name of the workspace.
     * @return Value object for saved search results.
     */
    public suspend fun getSavedSearch(
        resourceGroupName: String,
        savedSearchId: String,
        workspaceName: String,
    ): GetSavedSearchResult {
        val argument = GetSavedSearchPlainArgs(
            resourceGroupName = resourceGroupName,
            savedSearchId = savedSearchId,
            workspaceName = workspaceName,
        )
        return getSavedSearchResultToKotlin(getSavedSearchPlain(argument.toJava()).await())
    }

    /**
     * @see [getSavedSearch].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetSavedSearchPlainArgs].
     * @return Value object for saved search results.
     */
    public suspend fun getSavedSearch(argument: suspend GetSavedSearchPlainArgsBuilder.() -> Unit):
        GetSavedSearchResult {
        val builder = GetSavedSearchPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSavedSearchResultToKotlin(getSavedSearchPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the shared keys for a workspace.
     * Azure REST API version: 2020-08-01.
     * @param argument null
     * @return The shared keys for a workspace.
     */
    public suspend fun getSharedKeys(argument: GetSharedKeysPlainArgs): GetSharedKeysResult =
        getSharedKeysResultToKotlin(getSharedKeysPlain(argument.toJava()).await())

    /**
     * @see [getSharedKeys].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The shared keys for a workspace.
     */
    public suspend fun getSharedKeys(resourceGroupName: String, workspaceName: String):
        GetSharedKeysResult {
        val argument = GetSharedKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getSharedKeysResultToKotlin(getSharedKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getSharedKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetSharedKeysPlainArgs].
     * @return The shared keys for a workspace.
     */
    public suspend fun getSharedKeys(argument: suspend GetSharedKeysPlainArgsBuilder.() -> Unit):
        GetSharedKeysResult {
        val builder = GetSharedKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSharedKeysResultToKotlin(getSharedKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a storage insight instance.
     * Azure REST API version: 2020-08-01.
     * @param argument null
     * @return The top level storage insight resource container.
     */
    public suspend fun getStorageInsightConfig(argument: GetStorageInsightConfigPlainArgs):
        GetStorageInsightConfigResult =
        getStorageInsightConfigResultToKotlin(getStorageInsightConfigPlain(argument.toJava()).await())

    /**
     * @see [getStorageInsightConfig].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageInsightName Name of the storageInsightsConfigs resource
     * @param workspaceName The name of the workspace.
     * @return The top level storage insight resource container.
     */
    public suspend fun getStorageInsightConfig(
        resourceGroupName: String,
        storageInsightName: String,
        workspaceName: String,
    ): GetStorageInsightConfigResult {
        val argument = GetStorageInsightConfigPlainArgs(
            resourceGroupName = resourceGroupName,
            storageInsightName = storageInsightName,
            workspaceName = workspaceName,
        )
        return getStorageInsightConfigResultToKotlin(getStorageInsightConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageInsightConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetStorageInsightConfigPlainArgs].
     * @return The top level storage insight resource container.
     */
    public suspend
    fun getStorageInsightConfig(argument: suspend GetStorageInsightConfigPlainArgsBuilder.() -> Unit):
        GetStorageInsightConfigResult {
        val builder = GetStorageInsightConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageInsightConfigResultToKotlin(getStorageInsightConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Log Analytics workspace table.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return Workspace data table definition.
     */
    public suspend fun getTable(argument: GetTablePlainArgs): GetTableResult =
        getTableResultToKotlin(getTablePlain(argument.toJava()).await())

    /**
     * @see [getTable].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param tableName The name of the table.
     * @param workspaceName The name of the workspace.
     * @return Workspace data table definition.
     */
    public suspend fun getTable(
        resourceGroupName: String,
        tableName: String,
        workspaceName: String,
    ): GetTableResult {
        val argument = GetTablePlainArgs(
            resourceGroupName = resourceGroupName,
            tableName = tableName,
            workspaceName = workspaceName,
        )
        return getTableResultToKotlin(getTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getTable].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetTablePlainArgs].
     * @return Workspace data table definition.
     */
    public suspend fun getTable(argument: suspend GetTablePlainArgsBuilder.() -> Unit):
        GetTableResult {
        val builder = GetTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTableResultToKotlin(getTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workspace instance.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2015-11-01-preview, 2020-08-01, 2020-10-01, 2021-06-01, 2021-12-01-preview, 2023-09-01.
     * @param argument null
     * @return The top level Workspace resource container.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace.
     * @return The top level Workspace resource container.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return The top level Workspace resource container.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the shared keys for a workspace.
     * Azure REST API version: 2015-11-01-preview.
     * @param argument null
     * @return The shared keys for a workspace.
     */
    public suspend fun getWorkspaceSharedKeys(argument: GetWorkspaceSharedKeysPlainArgs):
        GetWorkspaceSharedKeysResult =
        getWorkspaceSharedKeysResultToKotlin(getWorkspaceSharedKeysPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceSharedKeys].
     * @param resourceGroupName The name of the resource group to get. The name is case insensitive.
     * @param workspaceName Name of the Log Analytics Workspace.
     * @return The shared keys for a workspace.
     */
    public suspend fun getWorkspaceSharedKeys(resourceGroupName: String, workspaceName: String):
        GetWorkspaceSharedKeysResult {
        val argument = GetWorkspaceSharedKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceSharedKeysResultToKotlin(getWorkspaceSharedKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceSharedKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationalinsights&#46;kotlin&#46;inputs&#46;GetWorkspaceSharedKeysPlainArgs].
     * @return The shared keys for a workspace.
     */
    public suspend
    fun getWorkspaceSharedKeys(argument: suspend GetWorkspaceSharedKeysPlainArgsBuilder.() -> Unit):
        GetWorkspaceSharedKeysResult {
        val builder = GetWorkspaceSharedKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceSharedKeysResultToKotlin(getWorkspaceSharedKeysPlain(builtArgument.toJava()).await())
    }
}
