@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.kotlin.outputs.LogAnalyticsQueryPackQueryPropertiesResponseRelated
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.LogAnalyticsQueryPackQueryPropertiesResponseRelated.Companion.toKotlin as logAnalyticsQueryPackQueryPropertiesResponseRelatedToKotlin
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Query].
 */
@PulumiTagMarker
public class QueryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueryArgs = QueryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueryArgsBuilder.() -> Unit) {
        val builder = QueryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Query {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.Query(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Query(builtJavaResource)
    }
}

/**
 * A Log Analytics QueryPack-Query definition.
 * Azure REST API version: 2019-09-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2019-09-01-preview.
 * ## Example Usage
 * ### QueryPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var query = new AzureNative.OperationalInsights.Query("query", new()
 *     {
 *         Body = @"let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * ",
 *         Description = "my description",
 *         DisplayName = "Exceptions - New in the last 24 hours",
 *         Id = "a449f8af-8e64-4b3a-9b16-5a7165ff98c4",
 *         QueryPackName = "my-querypack",
 *         Related = new AzureNative.OperationalInsights.Inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs
 *         {
 *             Categories = new[]
 *             {
 *                 "analytics",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         Tags =
 *         {
 *             { "my-label", new[]
 *             {
 *                 "label1",
 *             } },
 *             { "my-other-label", new[]
 *             {
 *                 "label2",
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewQuery(ctx, "query", &operationalinsights.QueryArgs{
 * 			Body: pulumi.String(`let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * `),
 * 			Description:   pulumi.String("my description"),
 * 			DisplayName:   pulumi.String("Exceptions - New in the last 24 hours"),
 * 			Id:            pulumi.String("a449f8af-8e64-4b3a-9b16-5a7165ff98c4"),
 * 			QueryPackName: pulumi.String("my-querypack"),
 * 			Related: &operationalinsights.LogAnalyticsQueryPackQueryPropertiesRelatedArgs{
 * 				Categories: pulumi.StringArray{
 * 					pulumi.String("analytics"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			Tags: pulumi.StringArrayMap{
 * 				"my-label": pulumi.StringArray{
 * 					pulumi.String("label1"),
 * 				},
 * 				"my-other-label": pulumi.StringArray{
 * 					pulumi.String("label2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.Query;
 * import com.pulumi.azurenative.operationalinsights.QueryArgs;
 * import com.pulumi.azurenative.operationalinsights.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var query = new Query("query", QueryArgs.builder()
 *             .body("""
 * let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 *             """)
 *             .description("my description")
 *             .displayName("Exceptions - New in the last 24 hours")
 *             .id("a449f8af-8e64-4b3a-9b16-5a7165ff98c4")
 *             .queryPackName("my-querypack")
 *             .related(LogAnalyticsQueryPackQueryPropertiesRelatedArgs.builder()
 *                 .categories("analytics")
 *                 .build())
 *             .resourceGroupName("my-resource-group")
 *             .tags(Map.ofEntries(
 *                 Map.entry("my-label", "label1"),
 *                 Map.entry("my-other-label", "label2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:Query a449f8af-8e64-4b3a-9b16-5a7165ff98c4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}
 * ```
 */
public class Query internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.Query,
) : KotlinCustomResource(javaResource, QueryMapper) {
    /**
     * Object Id of user creating the query.
     */
    public val author: Output<String>
        get() = javaResource.author().applyValue({ args0 -> args0 })

    /**
     * Body of the query.
     */
    public val body: Output<String>
        get() = javaResource.body().applyValue({ args0 -> args0 })

    /**
     * Description of the query.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique display name for your query within the Query Pack.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Azure resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Additional properties that can be set for the query.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The related metadata items for the function.
     */
    public val related: Output<LogAnalyticsQueryPackQueryPropertiesResponseRelated>?
        get() = javaResource.related().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    logAnalyticsQueryPackQueryPropertiesResponseRelatedToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Tags associated with the query.
     */
    public val tags: Output<Map<String, List<String>>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value.map({ args0 -> args0 }))
                }).toMap()
            }).orElse(null)
        })

    /**
     * Creation Date for the Log Analytics Query, in ISO 8601 format.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Last modified date of the Log Analytics Query, in ISO 8601 format.
     */
    public val timeModified: Output<String>
        get() = javaResource.timeModified().applyValue({ args0 -> args0 })

    /**
     * Azure resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object QueryMapper : ResourceMapper<Query> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.Query::class == javaResource::class

    override fun map(javaResource: Resource): Query = Query(
        javaResource as
            com.pulumi.azurenative.operationalinsights.Query,
    )
}

/**
 * @see [Query].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Query].
 */
public suspend fun query(name: String, block: suspend QueryResourceBuilder.() -> Unit): Query {
    val builder = QueryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Query].
 * @param name The _unique_ name of the resulting resource.
 */
public fun query(name: String): Query {
    val builder = QueryResourceBuilder()
    builder.name(name)
    return builder.build()
}
