@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.QueryArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Log Analytics QueryPack-Query definition.
 * Azure REST API version: 2019-09-01. Prior API version in Azure Native 1.x: 2019-09-01.
 * Other available API versions: 2019-09-01-preview.
 * ## Example Usage
 * ### QueryPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var query = new AzureNative.OperationalInsights.Query("query", new()
 *     {
 *         Body = @"let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * ",
 *         Description = "my description",
 *         DisplayName = "Exceptions - New in the last 24 hours",
 *         Id = "a449f8af-8e64-4b3a-9b16-5a7165ff98c4",
 *         QueryPackName = "my-querypack",
 *         Related = new AzureNative.OperationalInsights.Inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs
 *         {
 *             Categories = new[]
 *             {
 *                 "analytics",
 *             },
 *         },
 *         ResourceGroupName = "my-resource-group",
 *         Tags =
 *         {
 *             { "my-label", new[]
 *             {
 *                 "label1",
 *             } },
 *             { "my-other-label", new[]
 *             {
 *                 "label2",
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewQuery(ctx, "query", &operationalinsights.QueryArgs{
 * 			Body: pulumi.String(`let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 * `),
 * 			Description:   pulumi.String("my description"),
 * 			DisplayName:   pulumi.String("Exceptions - New in the last 24 hours"),
 * 			Id:            pulumi.String("a449f8af-8e64-4b3a-9b16-5a7165ff98c4"),
 * 			QueryPackName: pulumi.String("my-querypack"),
 * 			Related: &operationalinsights.LogAnalyticsQueryPackQueryPropertiesRelatedArgs{
 * 				Categories: pulumi.StringArray{
 * 					pulumi.String("analytics"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			Tags: pulumi.StringArrayMap{
 * 				"my-label": pulumi.StringArray{
 * 					pulumi.String("label1"),
 * 				},
 * 				"my-other-label": pulumi.StringArray{
 * 					pulumi.String("label2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.Query;
 * import com.pulumi.azurenative.operationalinsights.QueryArgs;
 * import com.pulumi.azurenative.operationalinsights.inputs.LogAnalyticsQueryPackQueryPropertiesRelatedArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var query = new Query("query", QueryArgs.builder()
 *             .body("""
 * let newExceptionsTimeRange = 1d;
 * let timeRangeToCheckBefore = 7d;
 * exceptions
 * | where timestamp < ago(timeRangeToCheckBefore)
 * | summarize count() by problemId
 * | join kind= rightanti (
 * exceptions
 * | where timestamp >= ago(newExceptionsTimeRange)
 * | extend stack = tostring(details[0].rawStack)
 * | summarize count(), dcount(user_AuthenticatedId), min(timestamp), max(timestamp), any(stack) by problemId
 * ) on problemId
 * | order by  count_ desc
 *             """)
 *             .description("my description")
 *             .displayName("Exceptions - New in the last 24 hours")
 *             .id("a449f8af-8e64-4b3a-9b16-5a7165ff98c4")
 *             .queryPackName("my-querypack")
 *             .related(LogAnalyticsQueryPackQueryPropertiesRelatedArgs.builder()
 *                 .categories("analytics")
 *                 .build())
 *             .resourceGroupName("my-resource-group")
 *             .tags(Map.ofEntries(
 *                 Map.entry("my-label", "label1"),
 *                 Map.entry("my-other-label", "label2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:Query a449f8af-8e64-4b3a-9b16-5a7165ff98c4 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/queryPacks/{queryPackName}/queries/{id}
 * ```
 * @property body Body of the query.
 * @property description Description of the query.
 * @property displayName Unique display name for your query within the Query Pack.
 * @property id The id of a specific query defined in the Log Analytics QueryPack
 * @property properties Additional properties that can be set for the query.
 * @property queryPackName The name of the Log Analytics QueryPack resource.
 * @property related The related metadata items for the function.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags associated with the query.
 */
public data class QueryArgs(
    public val body: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val queryPackName: Output<String>? = null,
    public val related: Output<LogAnalyticsQueryPackQueryPropertiesRelatedArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, List<String>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.QueryArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.QueryArgs =
        com.pulumi.azurenative.operationalinsights.QueryArgs.builder()
            .body(body?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .queryPackName(queryPackName?.applyValue({ args0 -> args0 }))
            .related(related?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0
                            }),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [QueryArgs].
 */
@PulumiTagMarker
public class QueryArgsBuilder internal constructor() {
    private var body: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var id: Output<String>? = null

    private var properties: Output<Any>? = null

    private var queryPackName: Output<String>? = null

    private var related: Output<LogAnalyticsQueryPackQueryPropertiesRelatedArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, List<String>>>? = null

    /**
     * @param value Body of the query.
     */
    @JvmName("wxhseouyjwuketbb")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Description of the query.
     */
    @JvmName("dnandecqqoepbirf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique display name for your query within the Query Pack.
     */
    @JvmName("prgrhltgicwynkdy")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The id of a specific query defined in the Log Analytics QueryPack
     */
    @JvmName("ptyetkkncssdfovb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Additional properties that can be set for the query.
     */
    @JvmName("bdrsqlqndiksihvc")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the Log Analytics QueryPack resource.
     */
    @JvmName("metupvykygepjbej")
    public suspend fun queryPackName(`value`: Output<String>) {
        this.queryPackName = value
    }

    /**
     * @param value The related metadata items for the function.
     */
    @JvmName("qkylpckymyisrcri")
    public suspend fun related(`value`: Output<LogAnalyticsQueryPackQueryPropertiesRelatedArgs>) {
        this.related = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tkltnfjfpmpborsx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags associated with the query.
     */
    @JvmName("mhwaeakxvwymnhvb")
    public suspend fun tags(`value`: Output<Map<String, List<String>>>) {
        this.tags = value
    }

    /**
     * @param value Body of the query.
     */
    @JvmName("avjxvkrkdhuqqinc")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Description of the query.
     */
    @JvmName("hmhctjrcuohyaelr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique display name for your query within the Query Pack.
     */
    @JvmName("gvtnmanmcyghhxpr")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The id of a specific query defined in the Log Analytics QueryPack
     */
    @JvmName("vqdiixlgtmiimpif")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Additional properties that can be set for the query.
     */
    @JvmName("omxtyjoffvcyagbd")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the Log Analytics QueryPack resource.
     */
    @JvmName("nnlwhxstfrcgbikg")
    public suspend fun queryPackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryPackName = mapped
    }

    /**
     * @param value The related metadata items for the function.
     */
    @JvmName("kpuinhymywvwwhar")
    public suspend fun related(`value`: LogAnalyticsQueryPackQueryPropertiesRelatedArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.related = mapped
    }

    /**
     * @param argument The related metadata items for the function.
     */
    @JvmName("kpmhomlluppyuiku")
    public suspend
    fun related(argument: suspend LogAnalyticsQueryPackQueryPropertiesRelatedArgsBuilder.() -> Unit) {
        val toBeMapped = LogAnalyticsQueryPackQueryPropertiesRelatedArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.related = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jewpfshxxgagfnoa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags associated with the query.
     */
    @JvmName("ffbdooptrxbdxqgs")
    public suspend fun tags(`value`: Map<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags associated with the query.
     */
    @JvmName("hwuewcvfvbxqrcmx")
    public fun tags(vararg values: Pair<String, List<String>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): QueryArgs = QueryArgs(
        body = body,
        description = description,
        displayName = displayName,
        id = id,
        properties = properties,
        queryPackName = queryPackName,
        related = related,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
