@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.StorageInsightConfigArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.StorageAccountArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.StorageAccountArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The top level storage insight resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### StorageInsightsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageInsightConfig = new AzureNative.OperationalInsights.StorageInsightConfig("storageInsightConfig", new()
 *     {
 *         Containers = new[]
 *         {
 *             "wad-iis-logfiles",
 *         },
 *         ResourceGroupName = "OIAutoRest5123",
 *         StorageAccount = new AzureNative.OperationalInsights.Inputs.StorageAccountArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945",
 *             Key = "1234",
 *         },
 *         StorageInsightName = "AzTestSI1110",
 *         Tables = new[]
 *         {
 *             "WADWindowsEventLogsTable",
 *             "LinuxSyslogVer2v0",
 *         },
 *         WorkspaceName = "aztest5048",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewStorageInsightConfig(ctx, "storageInsightConfig", &operationalinsights.StorageInsightConfigArgs{
 * 			Containers: pulumi.StringArray{
 * 				pulumi.String("wad-iis-logfiles"),
 * 			},
 * 			ResourceGroupName: pulumi.String("OIAutoRest5123"),
 * 			StorageAccount: &operationalinsights.StorageAccountArgs{
 * 				Id:  pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945"),
 * 				Key: pulumi.String("1234"),
 * 			},
 * 			StorageInsightName: pulumi.String("AzTestSI1110"),
 * 			Tables: pulumi.StringArray{
 * 				pulumi.String("WADWindowsEventLogsTable"),
 * 				pulumi.String("LinuxSyslogVer2v0"),
 * 			},
 * 			WorkspaceName: pulumi.String("aztest5048"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.StorageInsightConfig;
 * import com.pulumi.azurenative.operationalinsights.StorageInsightConfigArgs;
 * import com.pulumi.azurenative.operationalinsights.inputs.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageInsightConfig = new StorageInsightConfig("storageInsightConfig", StorageInsightConfigArgs.builder()
 *             .containers("wad-iis-logfiles")
 *             .resourceGroupName("OIAutoRest5123")
 *             .storageAccount(StorageAccountArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/OIAutoRest6987/providers/microsoft.storage/storageaccounts/AzTestFakeSA9945")
 *                 .key("1234")
 *                 .build())
 *             .storageInsightName("AzTestSI1110")
 *             .tables(
 *                 "WADWindowsEventLogsTable",
 *                 "LinuxSyslogVer2v0")
 *             .workspaceName("aztest5048")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:StorageInsightConfig AzTestSI1110 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/storageInsightConfigs/{storageInsightName}
 * ```
 * @property containers The names of the blob containers that the workspace should read
 * @property eTag The ETag of the storage insight.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageAccount The storage account connection details
 * @property storageInsightName Name of the storageInsightsConfigs resource
 * @property tables The names of the Azure tables that the workspace should read
 * @property tags Resource tags.
 * @property workspaceName The name of the workspace.
 */
public data class StorageInsightConfigArgs(
    public val containers: Output<List<String>>? = null,
    public val eTag: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccount: Output<StorageAccountArgs>? = null,
    public val storageInsightName: Output<String>? = null,
    public val tables: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.StorageInsightConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.StorageInsightConfigArgs =
        com.pulumi.azurenative.operationalinsights.StorageInsightConfigArgs.builder()
            .containers(containers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccount(storageAccount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageInsightName(storageInsightName?.applyValue({ args0 -> args0 }))
            .tables(tables?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageInsightConfigArgs].
 */
@PulumiTagMarker
public class StorageInsightConfigArgsBuilder internal constructor() {
    private var containers: Output<List<String>>? = null

    private var eTag: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccount: Output<StorageAccountArgs>? = null

    private var storageInsightName: Output<String>? = null

    private var tables: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The names of the blob containers that the workspace should read
     */
    @JvmName("liojlbocjpfmsppc")
    public suspend fun containers(`value`: Output<List<String>>) {
        this.containers = value
    }

    @JvmName("dytnmfyfgfsuagdr")
    public suspend fun containers(vararg values: Output<String>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values The names of the blob containers that the workspace should read
     */
    @JvmName("prdfpkqhvrdhawva")
    public suspend fun containers(values: List<Output<String>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value The ETag of the storage insight.
     */
    @JvmName("typcdihsbdimpali")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("asxkueksimppmgjm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The storage account connection details
     */
    @JvmName("dqkeewktbbteogcl")
    public suspend fun storageAccount(`value`: Output<StorageAccountArgs>) {
        this.storageAccount = value
    }

    /**
     * @param value Name of the storageInsightsConfigs resource
     */
    @JvmName("hchspfblwsbpptlr")
    public suspend fun storageInsightName(`value`: Output<String>) {
        this.storageInsightName = value
    }

    /**
     * @param value The names of the Azure tables that the workspace should read
     */
    @JvmName("fykvjfslyrhivuvj")
    public suspend fun tables(`value`: Output<List<String>>) {
        this.tables = value
    }

    @JvmName("gafyxjkxnluuvdqo")
    public suspend fun tables(vararg values: Output<String>) {
        this.tables = Output.all(values.asList())
    }

    /**
     * @param values The names of the Azure tables that the workspace should read
     */
    @JvmName("yvqoxbxtsvnfycaa")
    public suspend fun tables(values: List<Output<String>>) {
        this.tables = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ksvrtvdnquihlade")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("rbvkfoagdevahtwq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The names of the blob containers that the workspace should read
     */
    @JvmName("tvsnoswxfgumkqia")
    public suspend fun containers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param values The names of the blob containers that the workspace should read
     */
    @JvmName("npauebxolkbccmba")
    public suspend fun containers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value The ETag of the storage insight.
     */
    @JvmName("wqlmyplgevlpotqe")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yjllwinvcobdeyhi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The storage account connection details
     */
    @JvmName("olwrbwasddqdjpvq")
    public suspend fun storageAccount(`value`: StorageAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    /**
     * @param argument The storage account connection details
     */
    @JvmName("wctfhqqoehirvvou")
    public suspend fun storageAccount(argument: suspend StorageAccountArgsBuilder.() -> Unit) {
        val toBeMapped = StorageAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccount = mapped
    }

    /**
     * @param value Name of the storageInsightsConfigs resource
     */
    @JvmName("qcmqdgjrolgxsoxc")
    public suspend fun storageInsightName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageInsightName = mapped
    }

    /**
     * @param value The names of the Azure tables that the workspace should read
     */
    @JvmName("wcusufrduarxkeoh")
    public suspend fun tables(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tables = mapped
    }

    /**
     * @param values The names of the Azure tables that the workspace should read
     */
    @JvmName("bmukshlhvmanlvty")
    public suspend fun tables(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tables = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("debaekaaqkrfxaon")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tnmfohvkrqsmlgyj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("cgsubcyeaegtaxcl")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): StorageInsightConfigArgs = StorageInsightConfigArgs(
        containers = containers,
        eTag = eTag,
        resourceGroupName = resourceGroupName,
        storageAccount = storageAccount,
        storageInsightName = storageInsightName,
        tables = tables,
        tags = tags,
        workspaceName = workspaceName,
    )
}
