@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.TableArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.TablePlanEnum
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.RestoredLogsArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.RestoredLogsArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.SchemaArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.SchemaArgsBuilder
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.SearchResultsArgs
import com.pulumi.azurenative.operationalinsights.kotlin.inputs.SearchResultsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Workspace data table definition.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### TablesUpsert
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var table = new AzureNative.OperationalInsights.Table("table", new()
 *     {
 *         ResourceGroupName = "oiautorest6685",
 *         RetentionInDays = 45,
 *         Schema = new AzureNative.OperationalInsights.Inputs.SchemaArgs
 *         {
 *             Columns = new[]
 *             {
 *                 new AzureNative.OperationalInsights.Inputs.ColumnArgs
 *                 {
 *                     Name = "MyNewColumn",
 *                     Type = AzureNative.OperationalInsights.ColumnTypeEnum.Guid,
 *                 },
 *             },
 *             Name = "AzureNetworkFlow",
 *         },
 *         TableName = "AzureNetworkFlow",
 *         TotalRetentionInDays = 70,
 *         WorkspaceName = "oiautorest6685",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewTable(ctx, "table", &operationalinsights.TableArgs{
 * 			ResourceGroupName: pulumi.String("oiautorest6685"),
 * 			RetentionInDays:   pulumi.Int(45),
 * 			Schema: &operationalinsights.SchemaArgs{
 * 				Columns: operationalinsights.ColumnArray{
 * 					&operationalinsights.ColumnArgs{
 * 						Name: pulumi.String("MyNewColumn"),
 * 						Type: pulumi.String(operationalinsights.ColumnTypeEnumGuid),
 * 					},
 * 				},
 * 				Name: pulumi.String("AzureNetworkFlow"),
 * 			},
 * 			TableName:            pulumi.String("AzureNetworkFlow"),
 * 			TotalRetentionInDays: pulumi.Int(70),
 * 			WorkspaceName:        pulumi.String("oiautorest6685"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.Table;
 * import com.pulumi.azurenative.operationalinsights.TableArgs;
 * import com.pulumi.azurenative.operationalinsights.inputs.SchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var table = new Table("table", TableArgs.builder()
 *             .resourceGroupName("oiautorest6685")
 *             .retentionInDays(45)
 *             .schema(SchemaArgs.builder()
 *                 .columns(ColumnArgs.builder()
 *                     .name("MyNewColumn")
 *                     .type("guid")
 *                     .build())
 *                 .name("AzureNetworkFlow")
 *                 .build())
 *             .tableName("AzureNetworkFlow")
 *             .totalRetentionInDays(70)
 *             .workspaceName("oiautorest6685")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:Table AzureNetworkFlow /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/tables/{tableName}
 * ```
 * @property plan Instruct the system how to handle and charge the logs ingested to this table.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property restoredLogs Parameters of the restore operation that initiated this table.
 * @property retentionInDays The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
 * @property schema Table schema.
 * @property searchResults Parameters of the search job that initiated this table.
 * @property tableName The name of the table.
 * @property totalRetentionInDays The table total retention in days, between 4 and 4383. Setting this property to -1 will default to table retention.
 * @property workspaceName The name of the workspace.
 */
public data class TableArgs(
    public val plan: Output<Either<String, TablePlanEnum>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restoredLogs: Output<RestoredLogsArgs>? = null,
    public val retentionInDays: Output<Int>? = null,
    public val schema: Output<SchemaArgs>? = null,
    public val searchResults: Output<SearchResultsArgs>? = null,
    public val tableName: Output<String>? = null,
    public val totalRetentionInDays: Output<Int>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.TableArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.TableArgs =
        com.pulumi.azurenative.operationalinsights.TableArgs.builder()
            .plan(
                plan?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restoredLogs(restoredLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .searchResults(searchResults?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .totalRetentionInDays(totalRetentionInDays?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableArgs].
 */
@PulumiTagMarker
public class TableArgsBuilder internal constructor() {
    private var plan: Output<Either<String, TablePlanEnum>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restoredLogs: Output<RestoredLogsArgs>? = null

    private var retentionInDays: Output<Int>? = null

    private var schema: Output<SchemaArgs>? = null

    private var searchResults: Output<SearchResultsArgs>? = null

    private var tableName: Output<String>? = null

    private var totalRetentionInDays: Output<Int>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Instruct the system how to handle and charge the logs ingested to this table.
     */
    @JvmName("knclrtcehfmvvrna")
    public suspend fun plan(`value`: Output<Either<String, TablePlanEnum>>) {
        this.plan = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggnfmqyyxhgomaqi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Parameters of the restore operation that initiated this table.
     */
    @JvmName("kbxdandwpdflgucm")
    public suspend fun restoredLogs(`value`: Output<RestoredLogsArgs>) {
        this.restoredLogs = value
    }

    /**
     * @param value The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
     */
    @JvmName("xefwctrqovarlrlw")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value Table schema.
     */
    @JvmName("nbpbjoqlddxhrllx")
    public suspend fun schema(`value`: Output<SchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value Parameters of the search job that initiated this table.
     */
    @JvmName("tmhnbecpeouvgpym")
    public suspend fun searchResults(`value`: Output<SearchResultsArgs>) {
        this.searchResults = value
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("etlvbioaegmpoqig")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The table total retention in days, between 4 and 4383. Setting this property to -1 will default to table retention.
     */
    @JvmName("kgnsttkfvixymxna")
    public suspend fun totalRetentionInDays(`value`: Output<Int>) {
        this.totalRetentionInDays = value
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("wkjtutwbyobasyot")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Instruct the system how to handle and charge the logs ingested to this table.
     */
    @JvmName("htvqoepsmdwjflth")
    public suspend fun plan(`value`: Either<String, TablePlanEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param value Instruct the system how to handle and charge the logs ingested to this table.
     */
    @JvmName("bposvwvabyspvxnp")
    public fun plan(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TablePlanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param value Instruct the system how to handle and charge the logs ingested to this table.
     */
    @JvmName("povmnyobjhvimyjg")
    public fun plan(`value`: TablePlanEnum) {
        val toBeMapped = Either.ofRight<String, TablePlanEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hsodabylncwtjcdt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parameters of the restore operation that initiated this table.
     */
    @JvmName("xkiahhlehwugomlh")
    public suspend fun restoredLogs(`value`: RestoredLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoredLogs = mapped
    }

    /**
     * @param argument Parameters of the restore operation that initiated this table.
     */
    @JvmName("dasxjyeadgjtfcyr")
    public suspend fun restoredLogs(argument: suspend RestoredLogsArgsBuilder.() -> Unit) {
        val toBeMapped = RestoredLogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.restoredLogs = mapped
    }

    /**
     * @param value The table retention in days, between 4 and 730. Setting this property to -1 will default to the workspace retention.
     */
    @JvmName("klmmhgfkbrjpogbt")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    /**
     * @param value Table schema.
     */
    @JvmName("cpdoddgnglnfeyaf")
    public suspend fun schema(`value`: SchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument Table schema.
     */
    @JvmName("uhlgpflybkteqvwc")
    public suspend fun schema(argument: suspend SchemaArgsBuilder.() -> Unit) {
        val toBeMapped = SchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value Parameters of the search job that initiated this table.
     */
    @JvmName("mojupmuuntwmtllw")
    public suspend fun searchResults(`value`: SearchResultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchResults = mapped
    }

    /**
     * @param argument Parameters of the search job that initiated this table.
     */
    @JvmName("wptkattoapoidpyj")
    public suspend fun searchResults(argument: suspend SearchResultsArgsBuilder.() -> Unit) {
        val toBeMapped = SearchResultsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.searchResults = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("kwqqxgrtccqwwckj")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The table total retention in days, between 4 and 4383. Setting this property to -1 will default to table retention.
     */
    @JvmName("oeiloxubwyxxmold")
    public suspend fun totalRetentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalRetentionInDays = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("ghvhghwifoejlojp")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): TableArgs = TableArgs(
        plan = plan,
        resourceGroupName = resourceGroupName,
        restoredLogs = restoredLogs,
        retentionInDays = retentionInDays,
        schema = schema,
        searchResults = searchResults,
        tableName = tableName,
        totalRetentionInDays = totalRetentionInDays,
        workspaceName = workspaceName,
    )
}
