@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.ClusterSkuArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.ClusterSkuNameEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The cluster sku definition.
 * @property capacity The capacity value
 * @property name The name of the SKU.
 */
public data class ClusterSkuArgs(
    public val capacity: Output<Double>? = null,
    public val name: Output<Either<String, ClusterSkuNameEnum>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.ClusterSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.ClusterSkuArgs =
        com.pulumi.azurenative.operationalinsights.inputs.ClusterSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ClusterSkuArgs].
 */
@PulumiTagMarker
public class ClusterSkuArgsBuilder internal constructor() {
    private var capacity: Output<Double>? = null

    private var name: Output<Either<String, ClusterSkuNameEnum>>? = null

    /**
     * @param value The capacity value
     */
    @JvmName("nusvucoalwkbcwls")
    public suspend fun capacity(`value`: Output<Double>) {
        this.capacity = value
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("nmauclqayuuqkstu")
    public suspend fun name(`value`: Output<Either<String, ClusterSkuNameEnum>>) {
        this.name = value
    }

    /**
     * @param value The capacity value
     */
    @JvmName("mqfvfbtudkaumgkm")
    public suspend fun capacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("xsmvaxurywfpfuct")
    public suspend fun name(`value`: Either<String, ClusterSkuNameEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("lwyhelxogkdexxju")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterSkuNameEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("ngtchouointsokeq")
    public fun name(`value`: ClusterSkuNameEnum) {
        val toBeMapped = Either.ofRight<String, ClusterSkuNameEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterSkuArgs = ClusterSkuArgs(
        capacity = capacity,
        name = name,
    )
}
