@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetSavedSearchPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property savedSearchId The id of the saved search.
 * @property workspaceName The name of the workspace.
 */
public data class GetSavedSearchPlainArgs(
    public val resourceGroupName: String,
    public val savedSearchId: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetSavedSearchPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.GetSavedSearchPlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetSavedSearchPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .savedSearchId(savedSearchId.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSavedSearchPlainArgs].
 */
@PulumiTagMarker
public class GetSavedSearchPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var savedSearchId: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rghcwnrwogmsyepg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The id of the saved search.
     */
    @JvmName("gasqseufbvegmtis")
    public suspend fun savedSearchId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.savedSearchId = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("knweffcbbbxvplds")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetSavedSearchPlainArgs = GetSavedSearchPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        savedSearchId = savedSearchId ?: throw PulumiNullFieldException("savedSearchId"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
