@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tableName The name of the table.
 * @property workspaceName The name of the workspace.
 */
public data class GetTablePlainArgs(
    public val resourceGroupName: String,
    public val tableName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetTablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.GetTablePlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetTablePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTablePlainArgs].
 */
@PulumiTagMarker
public class GetTablePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var tableName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("huthwkmgwixareth")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the table.
     */
    @JvmName("tbwrbhbkhwrgdlph")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("xlcbymobsxyulkyt")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetTablePlainArgs = GetTablePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
