@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.RestoredLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Restore parameters.
 * @property endRestoreTime The timestamp to end the restore by (UTC).
 * @property sourceTable The table to restore data from.
 * @property startRestoreTime The timestamp to start the restore from (UTC).
 */
public data class RestoredLogsArgs(
    public val endRestoreTime: Output<String>? = null,
    public val sourceTable: Output<String>? = null,
    public val startRestoreTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.RestoredLogsArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.RestoredLogsArgs =
        com.pulumi.azurenative.operationalinsights.inputs.RestoredLogsArgs.builder()
            .endRestoreTime(endRestoreTime?.applyValue({ args0 -> args0 }))
            .sourceTable(sourceTable?.applyValue({ args0 -> args0 }))
            .startRestoreTime(startRestoreTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestoredLogsArgs].
 */
@PulumiTagMarker
public class RestoredLogsArgsBuilder internal constructor() {
    private var endRestoreTime: Output<String>? = null

    private var sourceTable: Output<String>? = null

    private var startRestoreTime: Output<String>? = null

    /**
     * @param value The timestamp to end the restore by (UTC).
     */
    @JvmName("ssvuffwlebpnmqvw")
    public suspend fun endRestoreTime(`value`: Output<String>) {
        this.endRestoreTime = value
    }

    /**
     * @param value The table to restore data from.
     */
    @JvmName("lwmvokfpgyysnotv")
    public suspend fun sourceTable(`value`: Output<String>) {
        this.sourceTable = value
    }

    /**
     * @param value The timestamp to start the restore from (UTC).
     */
    @JvmName("sbxapnvibaedkodo")
    public suspend fun startRestoreTime(`value`: Output<String>) {
        this.startRestoreTime = value
    }

    /**
     * @param value The timestamp to end the restore by (UTC).
     */
    @JvmName("xmhyvpklryueggal")
    public suspend fun endRestoreTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endRestoreTime = mapped
    }

    /**
     * @param value The table to restore data from.
     */
    @JvmName("rxtjemcwkqxbmqhn")
    public suspend fun sourceTable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceTable = mapped
    }

    /**
     * @param value The timestamp to start the restore from (UTC).
     */
    @JvmName("itlavyrwskxajjje")
    public suspend fun startRestoreTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startRestoreTime = mapped
    }

    internal fun build(): RestoredLogsArgs = RestoredLogsArgs(
        endRestoreTime = endRestoreTime,
        sourceTable = sourceTable,
        startRestoreTime = startRestoreTime,
    )
}
