@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.SchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Table's schema.
 * @property columns A list of table custom columns.
 * @property description Table description.
 * @property displayName Table display name.
 * @property name Table name.
 */
public data class SchemaArgs(
    public val columns: Output<List<ColumnArgs>>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.SchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.SchemaArgs =
        com.pulumi.azurenative.operationalinsights.inputs.SchemaArgs.builder()
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SchemaArgs].
 */
@PulumiTagMarker
public class SchemaArgsBuilder internal constructor() {
    private var columns: Output<List<ColumnArgs>>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value A list of table custom columns.
     */
    @JvmName("jyspdronfootuhqf")
    public suspend fun columns(`value`: Output<List<ColumnArgs>>) {
        this.columns = value
    }

    @JvmName("yvggvnyjxfbnjlug")
    public suspend fun columns(vararg values: Output<ColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values A list of table custom columns.
     */
    @JvmName("xxaaasnmoeaptowp")
    public suspend fun columns(values: List<Output<ColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Table description.
     */
    @JvmName("twitkejhbcikmnyj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Table display name.
     */
    @JvmName("pjvwauicrndsiutv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Table name.
     */
    @JvmName("lfbjqmbfvcuslwui")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of table custom columns.
     */
    @JvmName("torrtebuecpaujwc")
    public suspend fun columns(`value`: List<ColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument A list of table custom columns.
     */
    @JvmName("kietasdfkietpnxw")
    public suspend fun columns(argument: List<suspend ColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ColumnArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument A list of table custom columns.
     */
    @JvmName("sgqrxnrvmtkmttvy")
    public suspend fun columns(vararg argument: suspend ColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ColumnArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument A list of table custom columns.
     */
    @JvmName("lsirvwrsapatyqwu")
    public suspend fun columns(argument: suspend ColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ColumnArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values A list of table custom columns.
     */
    @JvmName("eryomgcirbovtgdi")
    public suspend fun columns(vararg values: ColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value Table description.
     */
    @JvmName("qjjnarmxheglxiun")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Table display name.
     */
    @JvmName("eitjptkgtliaghys")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Table name.
     */
    @JvmName("ttyrpgyuivcgfnll")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SchemaArgs = SchemaArgs(
        columns = columns,
        description = description,
        displayName = displayName,
        name = name,
    )
}
