@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The Capacity Reservation properties.
 * @property lastSkuUpdate The last time Sku was updated.
 * @property minCapacity Minimum CapacityReservation value in GB.
 */
public data class CapacityReservationPropertiesResponse(
    public val lastSkuUpdate: String,
    public val minCapacity: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.CapacityReservationPropertiesResponse):
            CapacityReservationPropertiesResponse = CapacityReservationPropertiesResponse(
            lastSkuUpdate = javaType.lastSkuUpdate(),
            minCapacity = javaType.minCapacity(),
        )
    }
}
