@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin

import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.ManagementConfigurationPropertiesResponse
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.ManagementConfigurationPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagementConfiguration].
 */
@PulumiTagMarker
public class ManagementConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementConfigurationArgs = ManagementConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagementConfigurationArgsBuilder.() -> Unit) {
        val builder = ManagementConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagementConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.operationsmanagement.ManagementConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementConfiguration(builtJavaResource)
    }
}

/**
 * The container for solution.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### ManagementConfigurationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementConfiguration = new AzureNative.OperationsManagement.ManagementConfiguration("managementConfiguration", new()
 *     {
 *         Location = "East US",
 *         ManagementConfigurationName = "managementConfiguration1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationsmanagement.NewManagementConfiguration(ctx, "managementConfiguration", &operationsmanagement.ManagementConfigurationArgs{
 * 			Location:                    pulumi.String("East US"),
 * 			ManagementConfigurationName: pulumi.String("managementConfiguration1"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationsmanagement.ManagementConfiguration;
 * import com.pulumi.azurenative.operationsmanagement.ManagementConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementConfiguration = new ManagementConfiguration("managementConfiguration", ManagementConfigurationArgs.builder()
 *             .location("East US")
 *             .managementConfigurationName("managementConfiguration1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationsmanagement:ManagementConfiguration managementConfiguration1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/ManagementConfigurations/{managementConfigurationName}
 * ```
 */
public class ManagementConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.operationsmanagement.ManagementConfiguration,
) : KotlinCustomResource(javaResource, ManagementConfigurationMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties for ManagementConfiguration object supported by the OperationsManagement resource provider.
     */
    public val properties: Output<ManagementConfigurationPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagementConfigurationMapper : ResourceMapper<ManagementConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationsmanagement.ManagementConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ManagementConfiguration =
        ManagementConfiguration(
            javaResource as
                com.pulumi.azurenative.operationsmanagement.ManagementConfiguration,
        )
}

/**
 * @see [ManagementConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementConfiguration].
 */
public suspend fun managementConfiguration(
    name: String,
    block: suspend ManagementConfigurationResourceBuilder.() -> Unit,
): ManagementConfiguration {
    val builder = ManagementConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementConfiguration(name: String): ManagementConfiguration {
    val builder = ManagementConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
