@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin

import com.pulumi.azurenative.operationsmanagement.ManagementConfigurationArgs.builder
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.ManagementConfigurationPropertiesArgs
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.ManagementConfigurationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The container for solution.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### ManagementConfigurationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementConfiguration = new AzureNative.OperationsManagement.ManagementConfiguration("managementConfiguration", new()
 *     {
 *         Location = "East US",
 *         ManagementConfigurationName = "managementConfiguration1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationsmanagement.NewManagementConfiguration(ctx, "managementConfiguration", &operationsmanagement.ManagementConfigurationArgs{
 * 			Location:                    pulumi.String("East US"),
 * 			ManagementConfigurationName: pulumi.String("managementConfiguration1"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationsmanagement.ManagementConfiguration;
 * import com.pulumi.azurenative.operationsmanagement.ManagementConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementConfiguration = new ManagementConfiguration("managementConfiguration", ManagementConfigurationArgs.builder()
 *             .location("East US")
 *             .managementConfigurationName("managementConfiguration1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationsmanagement:ManagementConfiguration managementConfiguration1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/ManagementConfigurations/{managementConfigurationName}
 * ```
 * @property location Resource location
 * @property managementConfigurationName User Management Configuration Name.
 * @property properties Properties for ManagementConfiguration object supported by the OperationsManagement resource provider.
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 */
public data class ManagementConfigurationArgs(
    public val location: Output<String>? = null,
    public val managementConfigurationName: Output<String>? = null,
    public val properties: Output<ManagementConfigurationPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.ManagementConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.operationsmanagement.ManagementConfigurationArgs =
        com.pulumi.azurenative.operationsmanagement.ManagementConfigurationArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .managementConfigurationName(managementConfigurationName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementConfigurationArgs].
 */
@PulumiTagMarker
public class ManagementConfigurationArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var managementConfigurationName: Output<String>? = null

    private var properties: Output<ManagementConfigurationPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Resource location
     */
    @JvmName("nghexufiqbaduptp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value User Management Configuration Name.
     */
    @JvmName("mqybwoilwiqtimsj")
    public suspend fun managementConfigurationName(`value`: Output<String>) {
        this.managementConfigurationName = value
    }

    /**
     * @param value Properties for ManagementConfiguration object supported by the OperationsManagement resource provider.
     */
    @JvmName("bgosihkqeohjhbll")
    public suspend fun properties(`value`: Output<ManagementConfigurationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("wgcuwgifyvbxmiea")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("bmmhcudrlunfianl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value User Management Configuration Name.
     */
    @JvmName("vnlqqyunbldjmphp")
    public suspend fun managementConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementConfigurationName = mapped
    }

    /**
     * @param value Properties for ManagementConfiguration object supported by the OperationsManagement resource provider.
     */
    @JvmName("nxdfaaliklnoottf")
    public suspend fun properties(`value`: ManagementConfigurationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties for ManagementConfiguration object supported by the OperationsManagement resource provider.
     */
    @JvmName("lptfkcufqpmwdunq")
    public suspend
    fun properties(argument: suspend ManagementConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementConfigurationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("wpuwccwnrehgcunk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagementConfigurationArgs = ManagementConfigurationArgs(
        location = location,
        managementConfigurationName = managementConfigurationName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
