@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.ManagementConfigurationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ManagementConfiguration properties supported by the OperationsManagement resource provider.
 * @property applicationId The applicationId of the appliance for this Management.
 * @property parameters Parameters to run the ARM template
 * @property parentResourceType The type of the parent resource.
 * @property template The Json object containing the ARM template to deploy
 */
public data class ManagementConfigurationPropertiesArgs(
    public val applicationId: Output<String>? = null,
    public val parameters: Output<List<ArmTemplateParameterArgs>>,
    public val parentResourceType: Output<String>,
    public val template: Output<Any>,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.ManagementConfigurationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationsmanagement.inputs.ManagementConfigurationPropertiesArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.ManagementConfigurationPropertiesArgs.builder()
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parentResourceType(parentResourceType.applyValue({ args0 -> args0 }))
            .template(template.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementConfigurationPropertiesArgs].
 */
@PulumiTagMarker
public class ManagementConfigurationPropertiesArgsBuilder internal constructor() {
    private var applicationId: Output<String>? = null

    private var parameters: Output<List<ArmTemplateParameterArgs>>? = null

    private var parentResourceType: Output<String>? = null

    private var template: Output<Any>? = null

    /**
     * @param value The applicationId of the appliance for this Management.
     */
    @JvmName("pcdqngiqvchkkkek")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Parameters to run the ARM template
     */
    @JvmName("booeswsmhiiytvsw")
    public suspend fun parameters(`value`: Output<List<ArmTemplateParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("ggyqpnajkqaqnnso")
    public suspend fun parameters(vararg values: Output<ArmTemplateParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Parameters to run the ARM template
     */
    @JvmName("rugvogwsumkiuvsb")
    public suspend fun parameters(values: List<Output<ArmTemplateParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The type of the parent resource.
     */
    @JvmName("etuvbsufkuveetjw")
    public suspend fun parentResourceType(`value`: Output<String>) {
        this.parentResourceType = value
    }

    /**
     * @param value The Json object containing the ARM template to deploy
     */
    @JvmName("ykvlgpakfssaichm")
    public suspend fun template(`value`: Output<Any>) {
        this.template = value
    }

    /**
     * @param value The applicationId of the appliance for this Management.
     */
    @JvmName("ntqpkjrbljahkorp")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Parameters to run the ARM template
     */
    @JvmName("kdbunaiuiscqnigb")
    public suspend fun parameters(`value`: List<ArmTemplateParameterArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters to run the ARM template
     */
    @JvmName("xinjseitmmhbphgg")
    public suspend
    fun parameters(argument: List<suspend ArmTemplateParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArmTemplateParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameters to run the ARM template
     */
    @JvmName("lbahtbrovlojkwng")
    public suspend fun parameters(
        vararg
        argument: suspend ArmTemplateParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ArmTemplateParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameters to run the ARM template
     */
    @JvmName("eycmrgrbnddxebyg")
    public suspend fun parameters(argument: suspend ArmTemplateParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ArmTemplateParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters to run the ARM template
     */
    @JvmName("ybcvsorewdqsqmvo")
    public suspend fun parameters(vararg values: ArmTemplateParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The type of the parent resource.
     */
    @JvmName("hmgtindvmvjncvlo")
    public suspend fun parentResourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parentResourceType = mapped
    }

    /**
     * @param value The Json object containing the ARM template to deploy
     */
    @JvmName("dlksaybdubqcxqrl")
    public suspend fun template(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.template = mapped
    }

    internal fun build(): ManagementConfigurationPropertiesArgs =
        ManagementConfigurationPropertiesArgs(
            applicationId = applicationId,
            parameters = parameters ?: throw PulumiNullFieldException("parameters"),
            parentResourceType = parentResourceType ?: throw PulumiNullFieldException("parentResourceType"),
            template = template ?: throw PulumiNullFieldException("template"),
        )
}
