@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileLinkResponse
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileThirdPartyConfigurationResponse
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfilesPropertiesResponseNetworkConfiguration
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileLinkResponse.Companion.toKotlin as contactProfileLinkResponseToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfileThirdPartyConfigurationResponse.Companion.toKotlin as contactProfileThirdPartyConfigurationResponseToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ContactProfilesPropertiesResponseNetworkConfiguration.Companion.toKotlin as contactProfilesPropertiesResponseNetworkConfigurationToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ContactProfile].
 */
@PulumiTagMarker
public class ContactProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactProfileArgs = ContactProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactProfileArgsBuilder.() -> Unit) {
        val builder = ContactProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ContactProfile {
        val builtJavaResource = com.pulumi.azurenative.orbital.ContactProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContactProfile(builtJavaResource)
    }
}

/**
 * Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a contact profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contactProfile = new AzureNative.Orbital.ContactProfile("contactProfile", new()
 *     {
 *         AutoTrackingConfiguration = AzureNative.Orbital.AutoTrackingConfiguration.Disabled,
 *         ContactProfileName = "CONTOSO-CP",
 *         EventHubUri = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub",
 *         Links = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 2,
 *                         CenterFrequencyMHz = 2250,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Uplink",
 *                             IpAddress = "10.1.0.4",
 *                             Port = "50000",
 *                             Protocol = AzureNative.Orbital.Protocol.TCP,
 *                         },
 *                         Name = "contoso-uplink-channel",
 *                     },
 *                 },
 *                 Direction = AzureNative.Orbital.Direction.Uplink,
 *                 EirpdBW = 45,
 *                 GainOverTemperature = 0,
 *                 Name = "contoso-uplink",
 *                 Polarization = AzureNative.Orbital.Polarization.LHCP,
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 15,
 *                         CenterFrequencyMHz = 8160,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Downlink",
 *                             IpAddress = "10.1.0.5",
 *                             Port = "50001",
 *                             Protocol = AzureNative.Orbital.Protocol.UDP,
 *                         },
 *                         Name = "contoso-downlink-channel",
 *                     },
 *                 },
 *                 Direction = AzureNative.Orbital.Direction.Downlink,
 *                 EirpdBW = 0,
 *                 GainOverTemperature = 25,
 *                 Name = "contoso-downlink",
 *                 Polarization = AzureNative.Orbital.Polarization.RHCP,
 *             },
 *         },
 *         Location = "eastus2",
 *         MinimumElevationDegrees = 5,
 *         MinimumViableContactDuration = "PT1M",
 *         NetworkConfiguration = new AzureNative.Orbital.Inputs.ContactProfilesPropertiesNetworkConfigurationArgs
 *         {
 *             SubnetId = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet",
 *         },
 *         ResourceGroupName = "contoso-Rgp",
 *         ThirdPartyConfigurations = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Ksat_MissionConfiguration",
 *                 ProviderName = "KSAT",
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Viasat_Configuration",
 *                 ProviderName = "VIASAT",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewContactProfile(ctx, "contactProfile", &orbital.ContactProfileArgs{
 * 			AutoTrackingConfiguration: orbital.AutoTrackingConfigurationDisabled,
 * 			ContactProfileName:        pulumi.String("CONTOSO-CP"),
 * 			EventHubUri:               pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub"),
 * 			Links: orbital.ContactProfileLinkArray{
 * 				&orbital.ContactProfileLinkArgs{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						&orbital.ContactProfileLinkChannelArgs{
 * 							BandwidthMHz:       pulumi.Float64(2),
 * 							CenterFrequencyMHz: pulumi.Float64(2250),
 * 							EndPoint: &orbital.EndPointArgs{
 * 								EndPointName: pulumi.String("ContosoTest_Uplink"),
 * 								IpAddress:    pulumi.String("10.1.0.4"),
 * 								Port:         pulumi.String("50000"),
 * 								Protocol:     pulumi.String(orbital.ProtocolTCP),
 * 							},
 * 							Name: pulumi.String("contoso-uplink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String(orbital.DirectionUplink),
 * 					EirpdBW:             pulumi.Float64(45),
 * 					GainOverTemperature: pulumi.Float64(0),
 * 					Name:                pulumi.String("contoso-uplink"),
 * 					Polarization:        pulumi.String(orbital.PolarizationLHCP),
 * 				},
 * 				&orbital.ContactProfileLinkArgs{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						&orbital.ContactProfileLinkChannelArgs{
 * 							BandwidthMHz:       pulumi.Float64(15),
 * 							CenterFrequencyMHz: pulumi.Float64(8160),
 * 							EndPoint: &orbital.EndPointArgs{
 * 								EndPointName: pulumi.String("ContosoTest_Downlink"),
 * 								IpAddress:    pulumi.String("10.1.0.5"),
 * 								Port:         pulumi.String("50001"),
 * 								Protocol:     pulumi.String(orbital.ProtocolUDP),
 * 							},
 * 							Name: pulumi.String("contoso-downlink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String(orbital.DirectionDownlink),
 * 					EirpdBW:             pulumi.Float64(0),
 * 					GainOverTemperature: pulumi.Float64(25),
 * 					Name:                pulumi.String("contoso-downlink"),
 * 					Polarization:        pulumi.String(orbital.PolarizationRHCP),
 * 				},
 * 			},
 * 			Location:                     pulumi.String("eastus2"),
 * 			MinimumElevationDegrees:      pulumi.Float64(5),
 * 			MinimumViableContactDuration: pulumi.String("PT1M"),
 * 			NetworkConfiguration: &orbital.ContactProfilesPropertiesNetworkConfigurationArgs{
 * 				SubnetId: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-Rgp"),
 * 			ThirdPartyConfigurations: orbital.ContactProfileThirdPartyConfigurationArray{
 * 				&orbital.ContactProfileThirdPartyConfigurationArgs{
 * 					MissionConfiguration: pulumi.String("Ksat_MissionConfiguration"),
 * 					ProviderName:         pulumi.String("KSAT"),
 * 				},
 * 				&orbital.ContactProfileThirdPartyConfigurationArgs{
 * 					MissionConfiguration: pulumi.String("Viasat_Configuration"),
 * 					ProviderName:         pulumi.String("VIASAT"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.ContactProfile;
 * import com.pulumi.azurenative.orbital.ContactProfileArgs;
 * import com.pulumi.azurenative.orbital.inputs.ContactProfileLinkArgs;
 * import com.pulumi.azurenative.orbital.inputs.ContactProfilesPropertiesNetworkConfigurationArgs;
 * import com.pulumi.azurenative.orbital.inputs.ContactProfileThirdPartyConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contactProfile = new ContactProfile("contactProfile", ContactProfileArgs.builder()
 *             .autoTrackingConfiguration("disabled")
 *             .contactProfileName("CONTOSO-CP")
 *             .eventHubUri("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub")
 *             .links(
 *                 ContactProfileLinkArgs.builder()
 *                     .channels(ContactProfileLinkChannelArgs.builder()
 *                         .bandwidthMHz(2)
 *                         .centerFrequencyMHz(2250)
 *                         .endPoint(EndPointArgs.builder()
 *                             .endPointName("ContosoTest_Uplink")
 *                             .ipAddress("10.1.0.4")
 *                             .port("50000")
 *                             .protocol("TCP")
 *                             .build())
 *                         .name("contoso-uplink-channel")
 *                         .build())
 *                     .direction("Uplink")
 *                     .eirpdBW(45)
 *                     .gainOverTemperature(0)
 *                     .name("contoso-uplink")
 *                     .polarization("LHCP")
 *                     .build(),
 *                 ContactProfileLinkArgs.builder()
 *                     .channels(ContactProfileLinkChannelArgs.builder()
 *                         .bandwidthMHz(15)
 *                         .centerFrequencyMHz(8160)
 *                         .endPoint(EndPointArgs.builder()
 *                             .endPointName("ContosoTest_Downlink")
 *                             .ipAddress("10.1.0.5")
 *                             .port("50001")
 *                             .protocol("UDP")
 *                             .build())
 *                         .name("contoso-downlink-channel")
 *                         .build())
 *                     .direction("Downlink")
 *                     .eirpdBW(0)
 *                     .gainOverTemperature(25)
 *                     .name("contoso-downlink")
 *                     .polarization("RHCP")
 *                     .build())
 *             .location("eastus2")
 *             .minimumElevationDegrees(5)
 *             .minimumViableContactDuration("PT1M")
 *             .networkConfiguration(ContactProfilesPropertiesNetworkConfigurationArgs.builder()
 *                 .subnetId("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet")
 *                 .build())
 *             .resourceGroupName("contoso-Rgp")
 *             .thirdPartyConfigurations(
 *                 ContactProfileThirdPartyConfigurationArgs.builder()
 *                     .missionConfiguration("Ksat_MissionConfiguration")
 *                     .providerName("KSAT")
 *                     .build(),
 *                 ContactProfileThirdPartyConfigurationArgs.builder()
 *                     .missionConfiguration("Viasat_Configuration")
 *                     .providerName("VIASAT")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:ContactProfile CONTOSO-CP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}
 * ```
 */
public class ContactProfile internal constructor(
    override val javaResource: com.pulumi.azurenative.orbital.ContactProfile,
) : KotlinCustomResource(javaResource, ContactProfileMapper) {
    /**
     * Auto-tracking configuration.
     */
    public val autoTrackingConfiguration: Output<String>?
        get() = javaResource.autoTrackingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
     */
    public val eventHubUri: Output<String>?
        get() = javaResource.eventHubUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    public val links: Output<List<ContactProfileLinkResponse>>
        get() = javaResource.links().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    contactProfileLinkResponseToKotlin(args0)
                })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    public val minimumElevationDegrees: Output<Double>?
        get() = javaResource.minimumElevationDegrees().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    public val minimumViableContactDuration: Output<String>?
        get() = javaResource.minimumViableContactDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network configuration of customer virtual network.
     */
    public val networkConfiguration: Output<ContactProfilesPropertiesResponseNetworkConfiguration>
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                contactProfilesPropertiesResponseNetworkConfigurationToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    public val thirdPartyConfigurations: Output<List<ContactProfileThirdPartyConfigurationResponse>>?
        get() = javaResource.thirdPartyConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        contactProfileThirdPartyConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContactProfileMapper : ResourceMapper<ContactProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.orbital.ContactProfile::class == javaResource::class

    override fun map(javaResource: Resource): ContactProfile = ContactProfile(
        javaResource as
            com.pulumi.azurenative.orbital.ContactProfile,
    )
}

/**
 * @see [ContactProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContactProfile].
 */
public suspend fun contactProfile(
    name: String,
    block: suspend ContactProfileResourceBuilder.() -> Unit,
): ContactProfile {
    val builder = ContactProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContactProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contactProfile(name: String): ContactProfile {
    val builder = ContactProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
