@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.ContactProfileArgs.builder
import com.pulumi.azurenative.orbital.kotlin.enums.AutoTrackingConfiguration
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileLinkArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileLinkArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileThirdPartyConfigurationArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfileThirdPartyConfigurationArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfilesPropertiesNetworkConfigurationArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactProfilesPropertiesNetworkConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a contact profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contactProfile = new AzureNative.Orbital.ContactProfile("contactProfile", new()
 *     {
 *         AutoTrackingConfiguration = AzureNative.Orbital.AutoTrackingConfiguration.Disabled,
 *         ContactProfileName = "CONTOSO-CP",
 *         EventHubUri = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub",
 *         Links = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 2,
 *                         CenterFrequencyMHz = 2250,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Uplink",
 *                             IpAddress = "10.1.0.4",
 *                             Port = "50000",
 *                             Protocol = AzureNative.Orbital.Protocol.TCP,
 *                         },
 *                         Name = "contoso-uplink-channel",
 *                     },
 *                 },
 *                 Direction = AzureNative.Orbital.Direction.Uplink,
 *                 EirpdBW = 45,
 *                 GainOverTemperature = 0,
 *                 Name = "contoso-uplink",
 *                 Polarization = AzureNative.Orbital.Polarization.LHCP,
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileLinkArgs
 *             {
 *                 Channels = new[]
 *                 {
 *                     new AzureNative.Orbital.Inputs.ContactProfileLinkChannelArgs
 *                     {
 *                         BandwidthMHz = 15,
 *                         CenterFrequencyMHz = 8160,
 *                         EndPoint = new AzureNative.Orbital.Inputs.EndPointArgs
 *                         {
 *                             EndPointName = "ContosoTest_Downlink",
 *                             IpAddress = "10.1.0.5",
 *                             Port = "50001",
 *                             Protocol = AzureNative.Orbital.Protocol.UDP,
 *                         },
 *                         Name = "contoso-downlink-channel",
 *                     },
 *                 },
 *                 Direction = AzureNative.Orbital.Direction.Downlink,
 *                 EirpdBW = 0,
 *                 GainOverTemperature = 25,
 *                 Name = "contoso-downlink",
 *                 Polarization = AzureNative.Orbital.Polarization.RHCP,
 *             },
 *         },
 *         Location = "eastus2",
 *         MinimumElevationDegrees = 5,
 *         MinimumViableContactDuration = "PT1M",
 *         NetworkConfiguration = new AzureNative.Orbital.Inputs.ContactProfilesPropertiesNetworkConfigurationArgs
 *         {
 *             SubnetId = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet",
 *         },
 *         ResourceGroupName = "contoso-Rgp",
 *         ThirdPartyConfigurations = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Ksat_MissionConfiguration",
 *                 ProviderName = "KSAT",
 *             },
 *             new AzureNative.Orbital.Inputs.ContactProfileThirdPartyConfigurationArgs
 *             {
 *                 MissionConfiguration = "Viasat_Configuration",
 *                 ProviderName = "VIASAT",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewContactProfile(ctx, "contactProfile", &orbital.ContactProfileArgs{
 * 			AutoTrackingConfiguration: orbital.AutoTrackingConfigurationDisabled,
 * 			ContactProfileName:        pulumi.String("CONTOSO-CP"),
 * 			EventHubUri:               pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub"),
 * 			Links: orbital.ContactProfileLinkArray{
 * 				&orbital.ContactProfileLinkArgs{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						&orbital.ContactProfileLinkChannelArgs{
 * 							BandwidthMHz:       pulumi.Float64(2),
 * 							CenterFrequencyMHz: pulumi.Float64(2250),
 * 							EndPoint: &orbital.EndPointArgs{
 * 								EndPointName: pulumi.String("ContosoTest_Uplink"),
 * 								IpAddress:    pulumi.String("10.1.0.4"),
 * 								Port:         pulumi.String("50000"),
 * 								Protocol:     pulumi.String(orbital.ProtocolTCP),
 * 							},
 * 							Name: pulumi.String("contoso-uplink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String(orbital.DirectionUplink),
 * 					EirpdBW:             pulumi.Float64(45),
 * 					GainOverTemperature: pulumi.Float64(0),
 * 					Name:                pulumi.String("contoso-uplink"),
 * 					Polarization:        pulumi.String(orbital.PolarizationLHCP),
 * 				},
 * 				&orbital.ContactProfileLinkArgs{
 * 					Channels: orbital.ContactProfileLinkChannelArray{
 * 						&orbital.ContactProfileLinkChannelArgs{
 * 							BandwidthMHz:       pulumi.Float64(15),
 * 							CenterFrequencyMHz: pulumi.Float64(8160),
 * 							EndPoint: &orbital.EndPointArgs{
 * 								EndPointName: pulumi.String("ContosoTest_Downlink"),
 * 								IpAddress:    pulumi.String("10.1.0.5"),
 * 								Port:         pulumi.String("50001"),
 * 								Protocol:     pulumi.String(orbital.ProtocolUDP),
 * 							},
 * 							Name: pulumi.String("contoso-downlink-channel"),
 * 						},
 * 					},
 * 					Direction:           pulumi.String(orbital.DirectionDownlink),
 * 					EirpdBW:             pulumi.Float64(0),
 * 					GainOverTemperature: pulumi.Float64(25),
 * 					Name:                pulumi.String("contoso-downlink"),
 * 					Polarization:        pulumi.String(orbital.PolarizationRHCP),
 * 				},
 * 			},
 * 			Location:                     pulumi.String("eastus2"),
 * 			MinimumElevationDegrees:      pulumi.Float64(5),
 * 			MinimumViableContactDuration: pulumi.String("PT1M"),
 * 			NetworkConfiguration: &orbital.ContactProfilesPropertiesNetworkConfigurationArgs{
 * 				SubnetId: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet"),
 * 			},
 * 			ResourceGroupName: pulumi.String("contoso-Rgp"),
 * 			ThirdPartyConfigurations: orbital.ContactProfileThirdPartyConfigurationArray{
 * 				&orbital.ContactProfileThirdPartyConfigurationArgs{
 * 					MissionConfiguration: pulumi.String("Ksat_MissionConfiguration"),
 * 					ProviderName:         pulumi.String("KSAT"),
 * 				},
 * 				&orbital.ContactProfileThirdPartyConfigurationArgs{
 * 					MissionConfiguration: pulumi.String("Viasat_Configuration"),
 * 					ProviderName:         pulumi.String("VIASAT"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.ContactProfile;
 * import com.pulumi.azurenative.orbital.ContactProfileArgs;
 * import com.pulumi.azurenative.orbital.inputs.ContactProfileLinkArgs;
 * import com.pulumi.azurenative.orbital.inputs.ContactProfilesPropertiesNetworkConfigurationArgs;
 * import com.pulumi.azurenative.orbital.inputs.ContactProfileThirdPartyConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contactProfile = new ContactProfile("contactProfile", ContactProfileArgs.builder()
 *             .autoTrackingConfiguration("disabled")
 *             .contactProfileName("CONTOSO-CP")
 *             .eventHubUri("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.EventHub/namespaces/contosoHub/eventhubs/contosoHub")
 *             .links(
 *                 ContactProfileLinkArgs.builder()
 *                     .channels(ContactProfileLinkChannelArgs.builder()
 *                         .bandwidthMHz(2)
 *                         .centerFrequencyMHz(2250)
 *                         .endPoint(EndPointArgs.builder()
 *                             .endPointName("ContosoTest_Uplink")
 *                             .ipAddress("10.1.0.4")
 *                             .port("50000")
 *                             .protocol("TCP")
 *                             .build())
 *                         .name("contoso-uplink-channel")
 *                         .build())
 *                     .direction("Uplink")
 *                     .eirpdBW(45)
 *                     .gainOverTemperature(0)
 *                     .name("contoso-uplink")
 *                     .polarization("LHCP")
 *                     .build(),
 *                 ContactProfileLinkArgs.builder()
 *                     .channels(ContactProfileLinkChannelArgs.builder()
 *                         .bandwidthMHz(15)
 *                         .centerFrequencyMHz(8160)
 *                         .endPoint(EndPointArgs.builder()
 *                             .endPointName("ContosoTest_Downlink")
 *                             .ipAddress("10.1.0.5")
 *                             .port("50001")
 *                             .protocol("UDP")
 *                             .build())
 *                         .name("contoso-downlink-channel")
 *                         .build())
 *                     .direction("Downlink")
 *                     .eirpdBW(0)
 *                     .gainOverTemperature(25)
 *                     .name("contoso-downlink")
 *                     .polarization("RHCP")
 *                     .build())
 *             .location("eastus2")
 *             .minimumElevationDegrees(5)
 *             .minimumViableContactDuration("PT1M")
 *             .networkConfiguration(ContactProfilesPropertiesNetworkConfigurationArgs.builder()
 *                 .subnetId("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/contoso-Rgp/providers/Microsoft.Network/virtualNetworks/contoso-vnet/subnets/orbital-delegated-subnet")
 *                 .build())
 *             .resourceGroupName("contoso-Rgp")
 *             .thirdPartyConfigurations(
 *                 ContactProfileThirdPartyConfigurationArgs.builder()
 *                     .missionConfiguration("Ksat_MissionConfiguration")
 *                     .providerName("KSAT")
 *                     .build(),
 *                 ContactProfileThirdPartyConfigurationArgs.builder()
 *                     .missionConfiguration("Viasat_Configuration")
 *                     .providerName("VIASAT")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:ContactProfile CONTOSO-CP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/contactProfiles/{contactProfileName}
 * ```
 * @property autoTrackingConfiguration Auto-tracking configuration.
 * @property contactProfileName Contact Profile name.
 * @property eventHubUri ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
 * @property links Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
 * @property location The geo-location where the resource lives
 * @property minimumElevationDegrees Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
 * @property minimumViableContactDuration Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
 * @property networkConfiguration Network configuration of customer virtual network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property thirdPartyConfigurations Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
 */
public data class ContactProfileArgs(
    public val autoTrackingConfiguration: Output<AutoTrackingConfiguration>? = null,
    public val contactProfileName: Output<String>? = null,
    public val eventHubUri: Output<String>? = null,
    public val links: Output<List<ContactProfileLinkArgs>>? = null,
    public val location: Output<String>? = null,
    public val minimumElevationDegrees: Output<Double>? = null,
    public val minimumViableContactDuration: Output<String>? = null,
    public val networkConfiguration: Output<ContactProfilesPropertiesNetworkConfigurationArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val thirdPartyConfigurations: Output<List<ContactProfileThirdPartyConfigurationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.ContactProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.ContactProfileArgs =
        com.pulumi.azurenative.orbital.ContactProfileArgs.builder()
            .autoTrackingConfiguration(
                autoTrackingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .contactProfileName(contactProfileName?.applyValue({ args0 -> args0 }))
            .eventHubUri(eventHubUri?.applyValue({ args0 -> args0 }))
            .links(links?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumElevationDegrees(minimumElevationDegrees?.applyValue({ args0 -> args0 }))
            .minimumViableContactDuration(minimumViableContactDuration?.applyValue({ args0 -> args0 }))
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .thirdPartyConfigurations(
                thirdPartyConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ContactProfileArgs].
 */
@PulumiTagMarker
public class ContactProfileArgsBuilder internal constructor() {
    private var autoTrackingConfiguration: Output<AutoTrackingConfiguration>? = null

    private var contactProfileName: Output<String>? = null

    private var eventHubUri: Output<String>? = null

    private var links: Output<List<ContactProfileLinkArgs>>? = null

    private var location: Output<String>? = null

    private var minimumElevationDegrees: Output<Double>? = null

    private var minimumViableContactDuration: Output<String>? = null

    private var networkConfiguration: Output<ContactProfilesPropertiesNetworkConfigurationArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var thirdPartyConfigurations: Output<List<ContactProfileThirdPartyConfigurationArgs>>? =
        null

    /**
     * @param value Auto-tracking configuration.
     */
    @JvmName("lmcymtrcibycbsca")
    public suspend fun autoTrackingConfiguration(`value`: Output<AutoTrackingConfiguration>) {
        this.autoTrackingConfiguration = value
    }

    /**
     * @param value Contact Profile name.
     */
    @JvmName("wnbflahpmjkacmje")
    public suspend fun contactProfileName(`value`: Output<String>) {
        this.contactProfileName = value
    }

    /**
     * @param value ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
     */
    @JvmName("dtmwswomxlmlpsiy")
    public suspend fun eventHubUri(`value`: Output<String>) {
        this.eventHubUri = value
    }

    /**
     * @param value Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("jlhvjkpensbomdst")
    public suspend fun links(`value`: Output<List<ContactProfileLinkArgs>>) {
        this.links = value
    }

    @JvmName("vobwedfxlkreyfdn")
    public suspend fun links(vararg values: Output<ContactProfileLinkArgs>) {
        this.links = Output.all(values.asList())
    }

    /**
     * @param values Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("qrassornvxvwaovi")
    public suspend fun links(values: List<Output<ContactProfileLinkArgs>>) {
        this.links = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rxolaulcmtkpjbdq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("nkyffkmoqiuecjgf")
    public suspend fun minimumElevationDegrees(`value`: Output<Double>) {
        this.minimumElevationDegrees = value
    }

    /**
     * @param value Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("mhhmxvdpouasjdtv")
    public suspend fun minimumViableContactDuration(`value`: Output<String>) {
        this.minimumViableContactDuration = value
    }

    /**
     * @param value Network configuration of customer virtual network.
     */
    @JvmName("xyhifgvyhwmnijes")
    public suspend
    fun networkConfiguration(`value`: Output<ContactProfilesPropertiesNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gthhrjbnbtknidmb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kwiqcyoxvljcgcvi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("rlfpwfnmyremkybw")
    public suspend
    fun thirdPartyConfigurations(`value`: Output<List<ContactProfileThirdPartyConfigurationArgs>>) {
        this.thirdPartyConfigurations = value
    }

    @JvmName("meuxosjpxepdxayp")
    public suspend fun thirdPartyConfigurations(
        vararg
        values: Output<ContactProfileThirdPartyConfigurationArgs>,
    ) {
        this.thirdPartyConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("ulhycrvcnqomvekn")
    public suspend
    fun thirdPartyConfigurations(values: List<Output<ContactProfileThirdPartyConfigurationArgs>>) {
        this.thirdPartyConfigurations = Output.all(values)
    }

    /**
     * @param value Auto-tracking configuration.
     */
    @JvmName("mchvndqxemclgafv")
    public suspend fun autoTrackingConfiguration(`value`: AutoTrackingConfiguration?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoTrackingConfiguration = mapped
    }

    /**
     * @param value Contact Profile name.
     */
    @JvmName("tgumjxlbynyjjwho")
    public suspend fun contactProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactProfileName = mapped
    }

    /**
     * @param value ARM resource identifier of the Event Hub used for telemetry. Requires granting Orbital Resource Provider the rights to send telemetry into the hub.
     */
    @JvmName("lyrpqgrypydlxxwr")
    public suspend fun eventHubUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubUri = mapped
    }

    /**
     * @param value Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("annmynjsitpogxlb")
    public suspend fun links(`value`: List<ContactProfileLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param argument Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("bamksjovvftaxydt")
    public suspend fun links(argument: List<suspend ContactProfileLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactProfileLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("rxbvvordsppjslms")
    public suspend fun links(vararg argument: suspend ContactProfileLinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContactProfileLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("qoubmlmfvoepwqxo")
    public suspend fun links(argument: suspend ContactProfileLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContactProfileLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param values Links of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("lyptjsesfxdipayq")
    public suspend fun links(vararg values: ContactProfileLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cctbxaifmpcuxanr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Minimum viable elevation for the contact in decimal degrees. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("wwntvwbdovbqmneq")
    public suspend fun minimumElevationDegrees(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumElevationDegrees = mapped
    }

    /**
     * @param value Minimum viable contact duration in ISO 8601 format. Used for listing the available contacts with a spacecraft at a given ground station.
     */
    @JvmName("nwfaqqgxilwouujb")
    public suspend fun minimumViableContactDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumViableContactDuration = mapped
    }

    /**
     * @param value Network configuration of customer virtual network.
     */
    @JvmName("gqkdivbfiaxraspg")
    public suspend
    fun networkConfiguration(`value`: ContactProfilesPropertiesNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Network configuration of customer virtual network.
     */
    @JvmName("vftnouatkcpdenvy")
    public suspend
    fun networkConfiguration(argument: suspend ContactProfilesPropertiesNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContactProfilesPropertiesNetworkConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lvnhclswtcosrgbu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lvvhlvfoykagfvyo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("olflbcivojetcncy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("eriuwvmpqcfxctrl")
    public suspend
    fun thirdPartyConfigurations(`value`: List<ContactProfileThirdPartyConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param argument Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("okeovvdipbelkjrc")
    public suspend
    fun thirdPartyConfigurations(argument: List<suspend ContactProfileThirdPartyConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactProfileThirdPartyConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param argument Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("scsklfabtlihdueh")
    public suspend fun thirdPartyConfigurations(
        vararg
        argument: suspend ContactProfileThirdPartyConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContactProfileThirdPartyConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param argument Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("kxwxtvkdufwmmltu")
    public suspend
    fun thirdPartyConfigurations(argument: suspend ContactProfileThirdPartyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContactProfileThirdPartyConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.thirdPartyConfigurations = mapped
    }

    /**
     * @param values Third-party mission configuration of the Contact Profile. Describes RF links, modem processing, and IP endpoints.
     */
    @JvmName("ykoitdugmwkbqydv")
    public suspend fun thirdPartyConfigurations(
        vararg
        values: ContactProfileThirdPartyConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thirdPartyConfigurations = mapped
    }

    internal fun build(): ContactProfileArgs = ContactProfileArgs(
        autoTrackingConfiguration = autoTrackingConfiguration,
        contactProfileName = contactProfileName,
        eventHubUri = eventHubUri,
        links = links,
        location = location,
        minimumElevationDegrees = minimumElevationDegrees,
        minimumViableContactDuration = minimumViableContactDuration,
        networkConfiguration = networkConfiguration,
        resourceGroupName = resourceGroupName,
        tags = tags,
        thirdPartyConfigurations = thirdPartyConfigurations,
    )
}
