@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.kotlin.outputs.EdgeSitesPropertiesResponseGlobalCommunicationsSite
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.orbital.kotlin.outputs.EdgeSitesPropertiesResponseGlobalCommunicationsSite.Companion.toKotlin as edgeSitesPropertiesResponseGlobalCommunicationsSiteToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EdgeSite].
 */
@PulumiTagMarker
public class EdgeSiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EdgeSiteArgs = EdgeSiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EdgeSiteArgsBuilder.() -> Unit) {
        val builder = EdgeSiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EdgeSite {
        val builtJavaResource = com.pulumi.azurenative.orbital.EdgeSite(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EdgeSite(builtJavaResource)
    }
}

/**
 * A customer's reference to a global communications site site.
 * Azure REST API version: 2024-03-01-preview.
 * Other available API versions: 2024-03-01.
 * ## Example Usage
 * ### Create Edge Site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var edgeSite = new AzureNative.Orbital.EdgeSite("edgeSite", new()
 *     {
 *         EdgeSiteName = "es1",
 *         GlobalCommunicationsSite = new AzureNative.Orbital.Inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewEdgeSite(ctx, "edgeSite", &orbital.EdgeSiteArgs{
 * 			EdgeSiteName: pulumi.String("es1"),
 * 			GlobalCommunicationsSite: &orbital.EdgeSitesPropertiesGlobalCommunicationsSiteArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.EdgeSite;
 * import com.pulumi.azurenative.orbital.EdgeSiteArgs;
 * import com.pulumi.azurenative.orbital.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var edgeSite = new EdgeSite("edgeSite", EdgeSiteArgs.builder()
 *             .edgeSiteName("es1")
 *             .globalCommunicationsSite(EdgeSitesPropertiesGlobalCommunicationsSiteArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon")
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:EdgeSite es1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/edgeSites/{edgeSiteName}
 * ```
 */
public class EdgeSite internal constructor(
    override val javaResource: com.pulumi.azurenative.orbital.EdgeSite,
) : KotlinCustomResource(javaResource, EdgeSiteMapper) {
    /**
     * A reference to global communications site.
     */
    public val globalCommunicationsSite: Output<EdgeSitesPropertiesResponseGlobalCommunicationsSite>
        get() = javaResource.globalCommunicationsSite().applyValue({ args0 ->
            args0.let({ args0 ->
                edgeSitesPropertiesResponseGlobalCommunicationsSiteToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EdgeSiteMapper : ResourceMapper<EdgeSite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.orbital.EdgeSite::class == javaResource::class

    override fun map(javaResource: Resource): EdgeSite = EdgeSite(
        javaResource as
            com.pulumi.azurenative.orbital.EdgeSite,
    )
}

/**
 * @see [EdgeSite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EdgeSite].
 */
public suspend fun edgeSite(name: String, block: suspend EdgeSiteResourceBuilder.() -> Unit):
    EdgeSite {
    val builder = EdgeSiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EdgeSite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun edgeSite(name: String): EdgeSite {
    val builder = EdgeSiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
