@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.kotlin.outputs.GroundStationsPropertiesResponseGlobalCommunicationsSite
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.orbital.kotlin.outputs.GroundStationsPropertiesResponseGlobalCommunicationsSite.Companion.toKotlin as groundStationsPropertiesResponseGlobalCommunicationsSiteToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [GroundStation].
 */
@PulumiTagMarker
public class GroundStationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroundStationArgs = GroundStationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroundStationArgsBuilder.() -> Unit) {
        val builder = GroundStationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroundStation {
        val builtJavaResource = com.pulumi.azurenative.orbital.GroundStation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroundStation(builtJavaResource)
    }
}

/**
 * Ground Station contains one or more antennas.
 * Azure REST API version: 2024-03-01-preview.
 * Other available API versions: 2024-03-01.
 * ## Example Usage
 * ### Create a ground station
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groundStation = new AzureNative.Orbital.GroundStation("groundStation", new()
 *     {
 *         AltitudeMeters = 1500.83,
 *         Capabilities = new[]
 *         {
 *             AzureNative.Orbital.Capability.Communication,
 *         },
 *         City = "redmond",
 *         GlobalCommunicationsSite = new AzureNative.Orbital.Inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon",
 *         },
 *         GroundStationName = "westus_gs1",
 *         LatitudeDegrees = -122.122,
 *         Location = "westus",
 *         LongitudeDegrees = 47.674,
 *         ProviderName = "Microsoft",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewGroundStation(ctx, "groundStation", &orbital.GroundStationArgs{
 * 			AltitudeMeters: pulumi.Float64(1500.83),
 * 			Capabilities: pulumi.StringArray{
 * 				pulumi.String(orbital.CapabilityCommunication),
 * 			},
 * 			City: pulumi.String("redmond"),
 * 			GlobalCommunicationsSite: &orbital.GroundStationsPropertiesGlobalCommunicationsSiteArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon"),
 * 			},
 * 			GroundStationName: pulumi.String("westus_gs1"),
 * 			LatitudeDegrees:   -122.122,
 * 			Location:          pulumi.String("westus"),
 * 			LongitudeDegrees:  pulumi.Float64(47.674),
 * 			ProviderName:      pulumi.String("Microsoft"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.GroundStation;
 * import com.pulumi.azurenative.orbital.GroundStationArgs;
 * import com.pulumi.azurenative.orbital.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groundStation = new GroundStation("groundStation", GroundStationArgs.builder()
 *             .altitudeMeters(1500.83)
 *             .capabilities("Communication")
 *             .city("redmond")
 *             .globalCommunicationsSite(GroundStationsPropertiesGlobalCommunicationsSiteArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon")
 *                 .build())
 *             .groundStationName("westus_gs1")
 *             .latitudeDegrees("TODO: GenUnaryOpExpression")
 *             .location("westus")
 *             .longitudeDegrees(47.674)
 *             .providerName("Microsoft")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:GroundStation westus_gs1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/groundStations/{groundStationName}
 * ```
 */
public class GroundStation internal constructor(
    override val javaResource: com.pulumi.azurenative.orbital.GroundStation,
) : KotlinCustomResource(javaResource, GroundStationMapper) {
    /**
     * Altitude of the ground station.
     */
    public val altitudeMeters: Output<Double>?
        get() = javaResource.altitudeMeters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Ground station capabilities.
     */
    public val capabilities: Output<List<String>>
        get() = javaResource.capabilities().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * City of ground station.
     */
    public val city: Output<String>?
        get() = javaResource.city().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A reference to global communications site.
     */
    public val globalCommunicationsSite:
        Output<GroundStationsPropertiesResponseGlobalCommunicationsSite>
        get() = javaResource.globalCommunicationsSite().applyValue({ args0 ->
            args0.let({ args0 ->
                groundStationsPropertiesResponseGlobalCommunicationsSiteToKotlin(args0)
            })
        })

    /**
     * Latitude of the ground station in decimal degrees.
     */
    public val latitudeDegrees: Output<Double>?
        get() = javaResource.latitudeDegrees().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Longitude of the ground station in decimal degrees.
     */
    public val longitudeDegrees: Output<Double>?
        get() = javaResource.longitudeDegrees().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Ground station provider name.
     */
    public val providerName: Output<String>?
        get() = javaResource.providerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Release Status of a ground station.
     */
    public val releaseMode: Output<String>
        get() = javaResource.releaseMode().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GroundStationMapper : ResourceMapper<GroundStation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.orbital.GroundStation::class == javaResource::class

    override fun map(javaResource: Resource): GroundStation = GroundStation(
        javaResource as
            com.pulumi.azurenative.orbital.GroundStation,
    )
}

/**
 * @see [GroundStation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroundStation].
 */
public suspend fun groundStation(
    name: String,
    block: suspend GroundStationResourceBuilder.() -> Unit,
): GroundStation {
    val builder = GroundStationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroundStation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groundStation(name: String): GroundStation {
    val builder = GroundStationResourceBuilder()
    builder.name(name)
    return builder.build()
}
