@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.GroundStationArgs.builder
import com.pulumi.azurenative.orbital.kotlin.enums.Capability
import com.pulumi.azurenative.orbital.kotlin.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Ground Station contains one or more antennas.
 * Azure REST API version: 2024-03-01-preview.
 * Other available API versions: 2024-03-01.
 * ## Example Usage
 * ### Create a ground station
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groundStation = new AzureNative.Orbital.GroundStation("groundStation", new()
 *     {
 *         AltitudeMeters = 1500.83,
 *         Capabilities = new[]
 *         {
 *             AzureNative.Orbital.Capability.Communication,
 *         },
 *         City = "redmond",
 *         GlobalCommunicationsSite = new AzureNative.Orbital.Inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon",
 *         },
 *         GroundStationName = "westus_gs1",
 *         LatitudeDegrees = -122.122,
 *         Location = "westus",
 *         LongitudeDegrees = 47.674,
 *         ProviderName = "Microsoft",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewGroundStation(ctx, "groundStation", &orbital.GroundStationArgs{
 * 			AltitudeMeters: pulumi.Float64(1500.83),
 * 			Capabilities: pulumi.StringArray{
 * 				pulumi.String(orbital.CapabilityCommunication),
 * 			},
 * 			City: pulumi.String("redmond"),
 * 			GlobalCommunicationsSite: &orbital.GroundStationsPropertiesGlobalCommunicationsSiteArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon"),
 * 			},
 * 			GroundStationName: pulumi.String("westus_gs1"),
 * 			LatitudeDegrees:   -122.122,
 * 			Location:          pulumi.String("westus"),
 * 			LongitudeDegrees:  pulumi.Float64(47.674),
 * 			ProviderName:      pulumi.String("Microsoft"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.GroundStation;
 * import com.pulumi.azurenative.orbital.GroundStationArgs;
 * import com.pulumi.azurenative.orbital.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groundStation = new GroundStation("groundStation", GroundStationArgs.builder()
 *             .altitudeMeters(1500.83)
 *             .capabilities("Communication")
 *             .city("redmond")
 *             .globalCommunicationsSite(GroundStationsPropertiesGlobalCommunicationsSiteArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon")
 *                 .build())
 *             .groundStationName("westus_gs1")
 *             .latitudeDegrees("TODO: GenUnaryOpExpression")
 *             .location("westus")
 *             .longitudeDegrees(47.674)
 *             .providerName("Microsoft")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:GroundStation westus_gs1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/groundStations/{groundStationName}
 * ```
 * @property altitudeMeters Altitude of the ground station.
 * @property capabilities Ground station capabilities.
 * @property city City of ground station.
 * @property globalCommunicationsSite A reference to global communications site.
 * @property groundStationName Ground Station name.
 * @property latitudeDegrees Latitude of the ground station in decimal degrees.
 * @property location The geo-location where the resource lives
 * @property longitudeDegrees Longitude of the ground station in decimal degrees.
 * @property providerName Ground station provider name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class GroundStationArgs(
    public val altitudeMeters: Output<Double>? = null,
    public val capabilities: Output<List<Either<String, Capability>>>? = null,
    public val city: Output<String>? = null,
    public val globalCommunicationsSite: Output<GroundStationsPropertiesGlobalCommunicationsSiteArgs>? =
        null,
    public val groundStationName: Output<String>? = null,
    public val latitudeDegrees: Output<Double>? = null,
    public val location: Output<String>? = null,
    public val longitudeDegrees: Output<Double>? = null,
    public val providerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.GroundStationArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.GroundStationArgs =
        com.pulumi.azurenative.orbital.GroundStationArgs.builder()
            .altitudeMeters(altitudeMeters?.applyValue({ args0 -> args0 }))
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .city(city?.applyValue({ args0 -> args0 }))
            .globalCommunicationsSite(
                globalCommunicationsSite?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .groundStationName(groundStationName?.applyValue({ args0 -> args0 }))
            .latitudeDegrees(latitudeDegrees?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .longitudeDegrees(longitudeDegrees?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GroundStationArgs].
 */
@PulumiTagMarker
public class GroundStationArgsBuilder internal constructor() {
    private var altitudeMeters: Output<Double>? = null

    private var capabilities: Output<List<Either<String, Capability>>>? = null

    private var city: Output<String>? = null

    private var globalCommunicationsSite:
        Output<GroundStationsPropertiesGlobalCommunicationsSiteArgs>? = null

    private var groundStationName: Output<String>? = null

    private var latitudeDegrees: Output<Double>? = null

    private var location: Output<String>? = null

    private var longitudeDegrees: Output<Double>? = null

    private var providerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Altitude of the ground station.
     */
    @JvmName("hyyycsujjytrlfep")
    public suspend fun altitudeMeters(`value`: Output<Double>) {
        this.altitudeMeters = value
    }

    /**
     * @param value Ground station capabilities.
     */
    @JvmName("hpuhsbvintfyixjl")
    public suspend fun capabilities(`value`: Output<List<Either<String, Capability>>>) {
        this.capabilities = value
    }

    @JvmName("ogyucejysqvlosla")
    public suspend fun capabilities(vararg values: Output<Either<String, Capability>>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values Ground station capabilities.
     */
    @JvmName("bpcnfctcncrqjslf")
    public suspend fun capabilities(values: List<Output<Either<String, Capability>>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value City of ground station.
     */
    @JvmName("tayvkijkusldurcf")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value A reference to global communications site.
     */
    @JvmName("qqjaknatnhaqfwxm")
    public suspend
    fun globalCommunicationsSite(`value`: Output<GroundStationsPropertiesGlobalCommunicationsSiteArgs>) {
        this.globalCommunicationsSite = value
    }

    /**
     * @param value Ground Station name.
     */
    @JvmName("tpbplgtuoddkevsb")
    public suspend fun groundStationName(`value`: Output<String>) {
        this.groundStationName = value
    }

    /**
     * @param value Latitude of the ground station in decimal degrees.
     */
    @JvmName("qsrskqvdjamgtwrb")
    public suspend fun latitudeDegrees(`value`: Output<Double>) {
        this.latitudeDegrees = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dkdhveiiaohwjobn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Longitude of the ground station in decimal degrees.
     */
    @JvmName("rlfewvhagrjhdfov")
    public suspend fun longitudeDegrees(`value`: Output<Double>) {
        this.longitudeDegrees = value
    }

    /**
     * @param value Ground station provider name.
     */
    @JvmName("odyaxmfmcosbvqtj")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vnlkufmtqeysrdnp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ethlwukeuwrsnqmq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Altitude of the ground station.
     */
    @JvmName("stnaxsfysyxusbga")
    public suspend fun altitudeMeters(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.altitudeMeters = mapped
    }

    /**
     * @param value Ground station capabilities.
     */
    @JvmName("imctagieojggegxk")
    public suspend fun capabilities(`value`: List<Either<String, Capability>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param values Ground station capabilities.
     */
    @JvmName("cbonhxthkuecojug")
    public suspend fun capabilities(vararg values: Either<String, Capability>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value City of ground station.
     */
    @JvmName("fwgtfwdugkovsbmi")
    public suspend fun city(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value A reference to global communications site.
     */
    @JvmName("gnmqflchvgvfxcuv")
    public suspend
    fun globalCommunicationsSite(`value`: GroundStationsPropertiesGlobalCommunicationsSiteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalCommunicationsSite = mapped
    }

    /**
     * @param argument A reference to global communications site.
     */
    @JvmName("uhekvegpvimakmkf")
    public suspend
    fun globalCommunicationsSite(argument: suspend GroundStationsPropertiesGlobalCommunicationsSiteArgsBuilder.() -> Unit) {
        val toBeMapped = GroundStationsPropertiesGlobalCommunicationsSiteArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.globalCommunicationsSite = mapped
    }

    /**
     * @param value Ground Station name.
     */
    @JvmName("nqxxhhwfgbdyhfsa")
    public suspend fun groundStationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groundStationName = mapped
    }

    /**
     * @param value Latitude of the ground station in decimal degrees.
     */
    @JvmName("xcxjonsygainavwo")
    public suspend fun latitudeDegrees(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latitudeDegrees = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ihiebqysakdnblcd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Longitude of the ground station in decimal degrees.
     */
    @JvmName("qagneubkhaischat")
    public suspend fun longitudeDegrees(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.longitudeDegrees = mapped
    }

    /**
     * @param value Ground station provider name.
     */
    @JvmName("cfyffstettkvqkhx")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pxfmkirttanekdwa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("veujyfmmumebyjon")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rhfvtawmlloemmmj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GroundStationArgs = GroundStationArgs(
        altitudeMeters = altitudeMeters,
        capabilities = capabilities,
        city = city,
        globalCommunicationsSite = globalCommunicationsSite,
        groundStationName = groundStationName,
        latitudeDegrees = latitudeDegrees,
        location = location,
        longitudeDegrees = longitudeDegrees,
        providerName = providerName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
