@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.OrbitalFunctions.getContactPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.getContactProfilePlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.getEdgeSitePlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.getGroundStationPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.getL2ConnectionPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.getSpacecraftPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.listEdgeSiteL2ConnectionsPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.listGroundStationL2ConnectionsPlain
import com.pulumi.azurenative.orbital.OrbitalFunctions.listSpacecraftAvailableContactsPlain
import com.pulumi.azurenative.orbital.kotlin.inputs.ContactParametersContactProfile
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactProfilePlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetContactProfilePlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.GetEdgeSitePlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetEdgeSitePlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.GetGroundStationPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetGroundStationPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.GetL2ConnectionPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetL2ConnectionPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.GetSpacecraftPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.GetSpacecraftPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ListEdgeSiteL2ConnectionsPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ListEdgeSiteL2ConnectionsPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ListGroundStationL2ConnectionsPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ListGroundStationL2ConnectionsPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.ListSpacecraftAvailableContactsPlainArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.ListSpacecraftAvailableContactsPlainArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactProfileResult
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactResult
import com.pulumi.azurenative.orbital.kotlin.outputs.GetEdgeSiteResult
import com.pulumi.azurenative.orbital.kotlin.outputs.GetGroundStationResult
import com.pulumi.azurenative.orbital.kotlin.outputs.GetL2ConnectionResult
import com.pulumi.azurenative.orbital.kotlin.outputs.GetSpacecraftResult
import com.pulumi.azurenative.orbital.kotlin.outputs.ListEdgeSiteL2ConnectionsResult
import com.pulumi.azurenative.orbital.kotlin.outputs.ListGroundStationL2ConnectionsResult
import com.pulumi.azurenative.orbital.kotlin.outputs.ListSpacecraftAvailableContactsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactProfileResult.Companion.toKotlin as getContactProfileResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.GetContactResult.Companion.toKotlin as getContactResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.GetEdgeSiteResult.Companion.toKotlin as getEdgeSiteResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.GetGroundStationResult.Companion.toKotlin as getGroundStationResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.GetL2ConnectionResult.Companion.toKotlin as getL2ConnectionResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.GetSpacecraftResult.Companion.toKotlin as getSpacecraftResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ListEdgeSiteL2ConnectionsResult.Companion.toKotlin as listEdgeSiteL2ConnectionsResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ListGroundStationL2ConnectionsResult.Companion.toKotlin as listGroundStationL2ConnectionsResultToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.ListSpacecraftAvailableContactsResult.Companion.toKotlin as listSpacecraftAvailableContactsResultToKotlin

public object OrbitalFunctions {
    /**
     * Gets the specified contact in a specified resource group.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Customer creates a contact resource for a spacecraft resource.
     */
    public suspend fun getContact(argument: GetContactPlainArgs): GetContactResult =
        getContactResultToKotlin(getContactPlain(argument.toJava()).await())

    /**
     * @see [getContact].
     * @param contactName Contact name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spacecraftName Spacecraft ID.
     * @return Customer creates a contact resource for a spacecraft resource.
     */
    public suspend fun getContact(
        contactName: String,
        resourceGroupName: String,
        spacecraftName: String,
    ): GetContactResult {
        val argument = GetContactPlainArgs(
            contactName = contactName,
            resourceGroupName = resourceGroupName,
            spacecraftName = spacecraftName,
        )
        return getContactResultToKotlin(getContactPlain(argument.toJava()).await())
    }

    /**
     * @see [getContact].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetContactPlainArgs].
     * @return Customer creates a contact resource for a spacecraft resource.
     */
    public suspend fun getContact(argument: suspend GetContactPlainArgsBuilder.() -> Unit):
        GetContactResult {
        val builder = GetContactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactResultToKotlin(getContactPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified contact Profile in a specified resource group.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
     */
    public suspend fun getContactProfile(argument: GetContactProfilePlainArgs):
        GetContactProfileResult =
        getContactProfileResultToKotlin(getContactProfilePlain(argument.toJava()).await())

    /**
     * @see [getContactProfile].
     * @param contactProfileName Contact Profile name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
     */
    public suspend fun getContactProfile(contactProfileName: String, resourceGroupName: String):
        GetContactProfileResult {
        val argument = GetContactProfilePlainArgs(
            contactProfileName = contactProfileName,
            resourceGroupName = resourceGroupName,
        )
        return getContactProfileResultToKotlin(getContactProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getContactProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetContactProfilePlainArgs].
     * @return Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.
     */
    public suspend
    fun getContactProfile(argument: suspend GetContactProfilePlainArgsBuilder.() -> Unit):
        GetContactProfileResult {
        val builder = GetContactProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactProfileResultToKotlin(getContactProfilePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified edge site in a specified resource group.
     * Azure REST API version: 2024-03-01-preview.
     * Other available API versions: 2024-03-01.
     * @param argument null
     * @return A customer's reference to a global communications site site.
     */
    public suspend fun getEdgeSite(argument: GetEdgeSitePlainArgs): GetEdgeSiteResult =
        getEdgeSiteResultToKotlin(getEdgeSitePlain(argument.toJava()).await())

    /**
     * @see [getEdgeSite].
     * @param edgeSiteName Edge site name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A customer's reference to a global communications site site.
     */
    public suspend fun getEdgeSite(edgeSiteName: String, resourceGroupName: String):
        GetEdgeSiteResult {
        val argument = GetEdgeSitePlainArgs(
            edgeSiteName = edgeSiteName,
            resourceGroupName = resourceGroupName,
        )
        return getEdgeSiteResultToKotlin(getEdgeSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getEdgeSite].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetEdgeSitePlainArgs].
     * @return A customer's reference to a global communications site site.
     */
    public suspend fun getEdgeSite(argument: suspend GetEdgeSitePlainArgsBuilder.() -> Unit):
        GetEdgeSiteResult {
        val builder = GetEdgeSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEdgeSiteResultToKotlin(getEdgeSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified ground station in a specified resource group.
     * Azure REST API version: 2024-03-01-preview.
     * Other available API versions: 2024-03-01.
     * @param argument null
     * @return Ground Station contains one or more antennas.
     */
    public suspend fun getGroundStation(argument: GetGroundStationPlainArgs): GetGroundStationResult =
        getGroundStationResultToKotlin(getGroundStationPlain(argument.toJava()).await())

    /**
     * @see [getGroundStation].
     * @param groundStationName Ground Station name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Ground Station contains one or more antennas.
     */
    public suspend fun getGroundStation(groundStationName: String, resourceGroupName: String):
        GetGroundStationResult {
        val argument = GetGroundStationPlainArgs(
            groundStationName = groundStationName,
            resourceGroupName = resourceGroupName,
        )
        return getGroundStationResultToKotlin(getGroundStationPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroundStation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetGroundStationPlainArgs].
     * @return Ground Station contains one or more antennas.
     */
    public suspend
    fun getGroundStation(argument: suspend GetGroundStationPlainArgsBuilder.() -> Unit):
        GetGroundStationResult {
        val builder = GetGroundStationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroundStationResultToKotlin(getGroundStationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified L2 connection in a specified resource group.
     * Azure REST API version: 2024-03-01-preview.
     * Other available API versions: 2024-03-01.
     * @param argument null
     * @return Connects an edge site to an orbital gateway and describes what layer 2 traffic to forward between them.
     */
    public suspend fun getL2Connection(argument: GetL2ConnectionPlainArgs): GetL2ConnectionResult =
        getL2ConnectionResultToKotlin(getL2ConnectionPlain(argument.toJava()).await())

    /**
     * @see [getL2Connection].
     * @param l2ConnectionName L2 Connection name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Connects an edge site to an orbital gateway and describes what layer 2 traffic to forward between them.
     */
    public suspend fun getL2Connection(l2ConnectionName: String, resourceGroupName: String):
        GetL2ConnectionResult {
        val argument = GetL2ConnectionPlainArgs(
            l2ConnectionName = l2ConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getL2ConnectionResultToKotlin(getL2ConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getL2Connection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetL2ConnectionPlainArgs].
     * @return Connects an edge site to an orbital gateway and describes what layer 2 traffic to forward between them.
     */
    public suspend fun getL2Connection(argument: suspend GetL2ConnectionPlainArgsBuilder.() -> Unit):
        GetL2ConnectionResult {
        val builder = GetL2ConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getL2ConnectionResultToKotlin(getL2ConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified spacecraft in a specified resource group.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Customer creates a spacecraft resource to schedule a contact.
     */
    public suspend fun getSpacecraft(argument: GetSpacecraftPlainArgs): GetSpacecraftResult =
        getSpacecraftResultToKotlin(getSpacecraftPlain(argument.toJava()).await())

    /**
     * @see [getSpacecraft].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spacecraftName Spacecraft ID.
     * @return Customer creates a spacecraft resource to schedule a contact.
     */
    public suspend fun getSpacecraft(resourceGroupName: String, spacecraftName: String):
        GetSpacecraftResult {
        val argument = GetSpacecraftPlainArgs(
            resourceGroupName = resourceGroupName,
            spacecraftName = spacecraftName,
        )
        return getSpacecraftResultToKotlin(getSpacecraftPlain(argument.toJava()).await())
    }

    /**
     * @see [getSpacecraft].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;GetSpacecraftPlainArgs].
     * @return Customer creates a spacecraft resource to schedule a contact.
     */
    public suspend fun getSpacecraft(argument: suspend GetSpacecraftPlainArgsBuilder.() -> Unit):
        GetSpacecraftResult {
        val builder = GetSpacecraftPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSpacecraftResultToKotlin(getSpacecraftPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of L2 Connections attached to an edge site.
     * Azure REST API version: 2024-03-01-preview.
     * Other available API versions: 2024-03-01.
     * @param argument null
     * @return Response for an API service call that lists the resource IDs of resources associated with another resource.
     */
    public suspend fun listEdgeSiteL2Connections(argument: ListEdgeSiteL2ConnectionsPlainArgs):
        ListEdgeSiteL2ConnectionsResult =
        listEdgeSiteL2ConnectionsResultToKotlin(listEdgeSiteL2ConnectionsPlain(argument.toJava()).await())

    /**
     * @see [listEdgeSiteL2Connections].
     * @param edgeSiteName Edge site name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for an API service call that lists the resource IDs of resources associated with another resource.
     */
    public suspend fun listEdgeSiteL2Connections(edgeSiteName: String, resourceGroupName: String):
        ListEdgeSiteL2ConnectionsResult {
        val argument = ListEdgeSiteL2ConnectionsPlainArgs(
            edgeSiteName = edgeSiteName,
            resourceGroupName = resourceGroupName,
        )
        return listEdgeSiteL2ConnectionsResultToKotlin(listEdgeSiteL2ConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [listEdgeSiteL2Connections].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;ListEdgeSiteL2ConnectionsPlainArgs].
     * @return Response for an API service call that lists the resource IDs of resources associated with another resource.
     */
    public suspend
    fun listEdgeSiteL2Connections(argument: suspend ListEdgeSiteL2ConnectionsPlainArgsBuilder.() -> Unit):
        ListEdgeSiteL2ConnectionsResult {
        val builder = ListEdgeSiteL2ConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listEdgeSiteL2ConnectionsResultToKotlin(listEdgeSiteL2ConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a list of L2 Connections attached to an ground station.
     * Azure REST API version: 2024-03-01-preview.
     * Other available API versions: 2024-03-01.
     * @param argument null
     * @return Response for an API service call that lists the resource IDs of resources associated with another resource.
     */
    public suspend
    fun listGroundStationL2Connections(argument: ListGroundStationL2ConnectionsPlainArgs):
        ListGroundStationL2ConnectionsResult =
        listGroundStationL2ConnectionsResultToKotlin(listGroundStationL2ConnectionsPlain(argument.toJava()).await())

    /**
     * @see [listGroundStationL2Connections].
     * @param groundStationName Ground Station name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for an API service call that lists the resource IDs of resources associated with another resource.
     */
    public suspend fun listGroundStationL2Connections(
        groundStationName: String,
        resourceGroupName: String,
    ): ListGroundStationL2ConnectionsResult {
        val argument = ListGroundStationL2ConnectionsPlainArgs(
            groundStationName = groundStationName,
            resourceGroupName = resourceGroupName,
        )
        return listGroundStationL2ConnectionsResultToKotlin(listGroundStationL2ConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [listGroundStationL2Connections].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;ListGroundStationL2ConnectionsPlainArgs].
     * @return Response for an API service call that lists the resource IDs of resources associated with another resource.
     */
    public suspend
    fun listGroundStationL2Connections(argument: suspend ListGroundStationL2ConnectionsPlainArgsBuilder.() -> Unit):
        ListGroundStationL2ConnectionsResult {
        val builder = ListGroundStationL2ConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listGroundStationL2ConnectionsResultToKotlin(listGroundStationL2ConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns list of available contacts. A contact is available if the spacecraft is visible from the ground station for more than the minimum viable contact duration provided in the contact profile.
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-03-01.
     * @param argument null
     * @return Response for the ListAvailableContacts API service call.
     */
    public suspend
    fun listSpacecraftAvailableContacts(argument: ListSpacecraftAvailableContactsPlainArgs):
        ListSpacecraftAvailableContactsResult =
        listSpacecraftAvailableContactsResultToKotlin(listSpacecraftAvailableContactsPlain(argument.toJava()).await())

    /**
     * @see [listSpacecraftAvailableContacts].
     * @param contactProfile The reference to the contact profile resource.
     * @param endTime End time of a contact (ISO 8601 UTC standard).
     * @param groundStationName Name of Azure Ground Station.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spacecraftName Spacecraft ID.
     * @param startTime Start time of a contact (ISO 8601 UTC standard).
     * @return Response for the ListAvailableContacts API service call.
     */
    public suspend fun listSpacecraftAvailableContacts(
        contactProfile: ContactParametersContactProfile,
        endTime: String,
        groundStationName: String,
        resourceGroupName: String,
        spacecraftName: String,
        startTime: String,
    ): ListSpacecraftAvailableContactsResult {
        val argument = ListSpacecraftAvailableContactsPlainArgs(
            contactProfile = contactProfile,
            endTime = endTime,
            groundStationName = groundStationName,
            resourceGroupName = resourceGroupName,
            spacecraftName = spacecraftName,
            startTime = startTime,
        )
        return listSpacecraftAvailableContactsResultToKotlin(listSpacecraftAvailableContactsPlain(argument.toJava()).await())
    }

    /**
     * @see [listSpacecraftAvailableContacts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;orbital&#46;kotlin&#46;inputs&#46;ListSpacecraftAvailableContactsPlainArgs].
     * @return Response for the ListAvailableContacts API service call.
     */
    public suspend
    fun listSpacecraftAvailableContacts(argument: suspend ListSpacecraftAvailableContactsPlainArgsBuilder.() -> Unit):
        ListSpacecraftAvailableContactsResult {
        val builder = ListSpacecraftAvailableContactsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSpacecraftAvailableContactsResultToKotlin(listSpacecraftAvailableContactsPlain(builtArgument.toJava()).await())
    }
}
