@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.kotlin.outputs.SpacecraftLinkResponse
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.orbital.kotlin.outputs.SpacecraftLinkResponse.Companion.toKotlin as spacecraftLinkResponseToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Spacecraft].
 */
@PulumiTagMarker
public class SpacecraftResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpacecraftArgs = SpacecraftArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpacecraftArgsBuilder.() -> Unit) {
        val builder = SpacecraftArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Spacecraft {
        val builtJavaResource = com.pulumi.azurenative.orbital.Spacecraft(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Spacecraft(builtJavaResource)
    }
}

/**
 * Customer creates a spacecraft resource to schedule a contact.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a spacecraft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var spacecraft = new AzureNative.Orbital.Spacecraft("spacecraft", new()
 *     {
 *         Links = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.SpacecraftLinkArgs
 *             {
 *                 BandwidthMHz = 2,
 *                 CenterFrequencyMHz = 2250,
 *                 Direction = AzureNative.Orbital.Direction.Uplink,
 *                 Name = "uplink_lhcp1",
 *                 Polarization = AzureNative.Orbital.Polarization.LHCP,
 *             },
 *             new AzureNative.Orbital.Inputs.SpacecraftLinkArgs
 *             {
 *                 BandwidthMHz = 15,
 *                 CenterFrequencyMHz = 8160,
 *                 Direction = AzureNative.Orbital.Direction.Downlink,
 *                 Name = "downlink_rhcp1",
 *                 Polarization = AzureNative.Orbital.Polarization.RHCP,
 *             },
 *         },
 *         Location = "eastus2",
 *         NoradId = "36411",
 *         ResourceGroupName = "contoso-Rgp",
 *         SpacecraftName = "CONTOSO_SAT",
 *         TitleLine = "CONTOSO_SAT",
 *         TleLine1 = "1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994",
 *         TleLine2 = "2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewSpacecraft(ctx, "spacecraft", &orbital.SpacecraftArgs{
 * 			Links: orbital.SpacecraftLinkArray{
 * 				&orbital.SpacecraftLinkArgs{
 * 					BandwidthMHz:       pulumi.Float64(2),
 * 					CenterFrequencyMHz: pulumi.Float64(2250),
 * 					Direction:          pulumi.String(orbital.DirectionUplink),
 * 					Name:               pulumi.String("uplink_lhcp1"),
 * 					Polarization:       pulumi.String(orbital.PolarizationLHCP),
 * 				},
 * 				&orbital.SpacecraftLinkArgs{
 * 					BandwidthMHz:       pulumi.Float64(15),
 * 					CenterFrequencyMHz: pulumi.Float64(8160),
 * 					Direction:          pulumi.String(orbital.DirectionDownlink),
 * 					Name:               pulumi.String("downlink_rhcp1"),
 * 					Polarization:       pulumi.String(orbital.PolarizationRHCP),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus2"),
 * 			NoradId:           pulumi.String("36411"),
 * 			ResourceGroupName: pulumi.String("contoso-Rgp"),
 * 			SpacecraftName:    pulumi.String("CONTOSO_SAT"),
 * 			TitleLine:         pulumi.String("CONTOSO_SAT"),
 * 			TleLine1:          pulumi.String("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
 * 			TleLine2:          pulumi.String("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.Spacecraft;
 * import com.pulumi.azurenative.orbital.SpacecraftArgs;
 * import com.pulumi.azurenative.orbital.inputs.SpacecraftLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var spacecraft = new Spacecraft("spacecraft", SpacecraftArgs.builder()
 *             .links(
 *                 SpacecraftLinkArgs.builder()
 *                     .bandwidthMHz(2)
 *                     .centerFrequencyMHz(2250)
 *                     .direction("Uplink")
 *                     .name("uplink_lhcp1")
 *                     .polarization("LHCP")
 *                     .build(),
 *                 SpacecraftLinkArgs.builder()
 *                     .bandwidthMHz(15)
 *                     .centerFrequencyMHz(8160)
 *                     .direction("Downlink")
 *                     .name("downlink_rhcp1")
 *                     .polarization("RHCP")
 *                     .build())
 *             .location("eastus2")
 *             .noradId("36411")
 *             .resourceGroupName("contoso-Rgp")
 *             .spacecraftName("CONTOSO_SAT")
 *             .titleLine("CONTOSO_SAT")
 *             .tleLine1("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994")
 *             .tleLine2("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:Spacecraft CONTOSO_SAT /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/spacecrafts/{spacecraftName}
 * ```
 */
public class Spacecraft internal constructor(
    override val javaResource: com.pulumi.azurenative.orbital.Spacecraft,
) : KotlinCustomResource(javaResource, SpacecraftMapper) {
    /**
     * Immutable list of Spacecraft links.
     */
    public val links: Output<List<SpacecraftLinkResponse>>
        get() = javaResource.links().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    spacecraftLinkResponseToKotlin(args0)
                })
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * NORAD ID of the spacecraft.
     */
    public val noradId: Output<String>?
        get() = javaResource.noradId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Title line of the two-line element set (TLE).
     */
    public val titleLine: Output<String>
        get() = javaResource.titleLine().applyValue({ args0 -> args0 })

    /**
     * Line 1 of the two-line element set (TLE).
     */
    public val tleLine1: Output<String>
        get() = javaResource.tleLine1().applyValue({ args0 -> args0 })

    /**
     * Line 2 of the two-line element set (TLE).
     */
    public val tleLine2: Output<String>
        get() = javaResource.tleLine2().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SpacecraftMapper : ResourceMapper<Spacecraft> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.orbital.Spacecraft::class == javaResource::class

    override fun map(javaResource: Resource): Spacecraft = Spacecraft(
        javaResource as
            com.pulumi.azurenative.orbital.Spacecraft,
    )
}

/**
 * @see [Spacecraft].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Spacecraft].
 */
public suspend fun spacecraft(name: String, block: suspend SpacecraftResourceBuilder.() -> Unit):
    Spacecraft {
    val builder = SpacecraftResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Spacecraft].
 * @param name The _unique_ name of the resulting resource.
 */
public fun spacecraft(name: String): Spacecraft {
    val builder = SpacecraftResourceBuilder()
    builder.name(name)
    return builder.build()
}
