@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Capability of the Ground Station.
 */
public enum class Capability(
    public val javaValue: com.pulumi.azurenative.orbital.enums.Capability,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.enums.Capability> {
    EarthObservation(com.pulumi.azurenative.orbital.enums.Capability.EarthObservation),
    Communication(com.pulumi.azurenative.orbital.enums.Capability.Communication),
    ;

    override fun toJava(): com.pulumi.azurenative.orbital.enums.Capability = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.enums.Capability): Capability =
            Capability.values().first { it.javaValue == javaType }
    }
}
