@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ContactParametersContactProfile.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The reference to the contact profile resource.
 * @property id Resource ID.
 */
public data class ContactParametersContactProfile(
    public val id: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ContactParametersContactProfile> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.ContactParametersContactProfile =
        com.pulumi.azurenative.orbital.inputs.ContactParametersContactProfile.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactParametersContactProfile].
 */
@PulumiTagMarker
public class ContactParametersContactProfileBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("qhgvjvfiqgdsaixm")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): ContactParametersContactProfile = ContactParametersContactProfile(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
