@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ContactProfileLinkChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contact Profile Link Channel.
 * @property bandwidthMHz Bandwidth in MHz.
 * @property centerFrequencyMHz Center Frequency in MHz.
 * @property decodingConfiguration Currently unused.
 * @property demodulationConfiguration Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
 * @property encodingConfiguration Currently unused.
 * @property endPoint Customer end point to store and retrieve data during a contact with the spacecraft.
 * @property modulationConfiguration Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
 * @property name Channel name.
 */
public data class ContactProfileLinkChannelArgs(
    public val bandwidthMHz: Output<Double>,
    public val centerFrequencyMHz: Output<Double>,
    public val decodingConfiguration: Output<String>? = null,
    public val demodulationConfiguration: Output<String>? = null,
    public val encodingConfiguration: Output<String>? = null,
    public val endPoint: Output<EndPointArgs>,
    public val modulationConfiguration: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ContactProfileLinkChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.ContactProfileLinkChannelArgs =
        com.pulumi.azurenative.orbital.inputs.ContactProfileLinkChannelArgs.builder()
            .bandwidthMHz(bandwidthMHz.applyValue({ args0 -> args0 }))
            .centerFrequencyMHz(centerFrequencyMHz.applyValue({ args0 -> args0 }))
            .decodingConfiguration(decodingConfiguration?.applyValue({ args0 -> args0 }))
            .demodulationConfiguration(demodulationConfiguration?.applyValue({ args0 -> args0 }))
            .encodingConfiguration(encodingConfiguration?.applyValue({ args0 -> args0 }))
            .endPoint(endPoint.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modulationConfiguration(modulationConfiguration?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactProfileLinkChannelArgs].
 */
@PulumiTagMarker
public class ContactProfileLinkChannelArgsBuilder internal constructor() {
    private var bandwidthMHz: Output<Double>? = null

    private var centerFrequencyMHz: Output<Double>? = null

    private var decodingConfiguration: Output<String>? = null

    private var demodulationConfiguration: Output<String>? = null

    private var encodingConfiguration: Output<String>? = null

    private var endPoint: Output<EndPointArgs>? = null

    private var modulationConfiguration: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Bandwidth in MHz.
     */
    @JvmName("fpuajixukwyrjvhk")
    public suspend fun bandwidthMHz(`value`: Output<Double>) {
        this.bandwidthMHz = value
    }

    /**
     * @param value Center Frequency in MHz.
     */
    @JvmName("jvkhsrrmdyqqiwdx")
    public suspend fun centerFrequencyMHz(`value`: Output<Double>) {
        this.centerFrequencyMHz = value
    }

    /**
     * @param value Currently unused.
     */
    @JvmName("lwhpprnryrjncivs")
    public suspend fun decodingConfiguration(`value`: Output<String>) {
        this.decodingConfiguration = value
    }

    /**
     * @param value Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
     */
    @JvmName("oufdcyoauswkvqae")
    public suspend fun demodulationConfiguration(`value`: Output<String>) {
        this.demodulationConfiguration = value
    }

    /**
     * @param value Currently unused.
     */
    @JvmName("qqpcdginbxajppsq")
    public suspend fun encodingConfiguration(`value`: Output<String>) {
        this.encodingConfiguration = value
    }

    /**
     * @param value Customer end point to store and retrieve data during a contact with the spacecraft.
     */
    @JvmName("lbeqifyimdvhjryt")
    public suspend fun endPoint(`value`: Output<EndPointArgs>) {
        this.endPoint = value
    }

    /**
     * @param value Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
     */
    @JvmName("iuvodhnuajchogae")
    public suspend fun modulationConfiguration(`value`: Output<String>) {
        this.modulationConfiguration = value
    }

    /**
     * @param value Channel name.
     */
    @JvmName("mntgjirxntbrtvyf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Bandwidth in MHz.
     */
    @JvmName("urgmwmmauqltqryb")
    public suspend fun bandwidthMHz(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bandwidthMHz = mapped
    }

    /**
     * @param value Center Frequency in MHz.
     */
    @JvmName("opsjghjflijhfvcq")
    public suspend fun centerFrequencyMHz(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.centerFrequencyMHz = mapped
    }

    /**
     * @param value Currently unused.
     */
    @JvmName("hskparbfeoqbbdik")
    public suspend fun decodingConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decodingConfiguration = mapped
    }

    /**
     * @param value Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
     */
    @JvmName("awbmlaqwqgaflfox")
    public suspend fun demodulationConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.demodulationConfiguration = mapped
    }

    /**
     * @param value Currently unused.
     */
    @JvmName("pbocembsmjfeeuef")
    public suspend fun encodingConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodingConfiguration = mapped
    }

    /**
     * @param value Customer end point to store and retrieve data during a contact with the spacecraft.
     */
    @JvmName("ewxvnluuisaxsflw")
    public suspend fun endPoint(`value`: EndPointArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endPoint = mapped
    }

    /**
     * @param argument Customer end point to store and retrieve data during a contact with the spacecraft.
     */
    @JvmName("vxkeiyqvgesyaoba")
    public suspend fun endPoint(argument: suspend EndPointArgsBuilder.() -> Unit) {
        val toBeMapped = EndPointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endPoint = mapped
    }

    /**
     * @param value Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
     */
    @JvmName("iisfbdhgifrwwsbc")
    public suspend fun modulationConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modulationConfiguration = mapped
    }

    /**
     * @param value Channel name.
     */
    @JvmName("hddipkgudeipylfx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ContactProfileLinkChannelArgs = ContactProfileLinkChannelArgs(
        bandwidthMHz = bandwidthMHz ?: throw PulumiNullFieldException("bandwidthMHz"),
        centerFrequencyMHz = centerFrequencyMHz ?: throw PulumiNullFieldException("centerFrequencyMHz"),
        decodingConfiguration = decodingConfiguration,
        demodulationConfiguration = demodulationConfiguration,
        encodingConfiguration = encodingConfiguration,
        endPoint = endPoint ?: throw PulumiNullFieldException("endPoint"),
        modulationConfiguration = modulationConfiguration,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
