@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.EndPointArgs.builder
import com.pulumi.azurenative.orbital.kotlin.enums.Protocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Customer end point to store and retrieve data during a contact with the spacecraft.
 * @property endPointName Name of an end point.
 * @property ipAddress IP Address (IPv4).
 * @property port TCP port to listen on to receive data.
 * @property protocol Protocol either UDP or TCP.
 */
public data class EndPointArgs(
    public val endPointName: Output<String>,
    public val ipAddress: Output<String>,
    public val port: Output<String>,
    public val protocol: Output<Either<String, Protocol>>,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.EndPointArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.EndPointArgs =
        com.pulumi.azurenative.orbital.inputs.EndPointArgs.builder()
            .endPointName(endPointName.applyValue({ args0 -> args0 }))
            .ipAddress(ipAddress.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .protocol(
                protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EndPointArgs].
 */
@PulumiTagMarker
public class EndPointArgsBuilder internal constructor() {
    private var endPointName: Output<String>? = null

    private var ipAddress: Output<String>? = null

    private var port: Output<String>? = null

    private var protocol: Output<Either<String, Protocol>>? = null

    /**
     * @param value Name of an end point.
     */
    @JvmName("chamglocghjftckh")
    public suspend fun endPointName(`value`: Output<String>) {
        this.endPointName = value
    }

    /**
     * @param value IP Address (IPv4).
     */
    @JvmName("jjycfxcupdeaqics")
    public suspend fun ipAddress(`value`: Output<String>) {
        this.ipAddress = value
    }

    /**
     * @param value TCP port to listen on to receive data.
     */
    @JvmName("lsiemsxqrncuprxk")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Protocol either UDP or TCP.
     */
    @JvmName("ramqnpsmbdxujaxm")
    public suspend fun protocol(`value`: Output<Either<String, Protocol>>) {
        this.protocol = value
    }

    /**
     * @param value Name of an end point.
     */
    @JvmName("khsbocaiuwcmrtcl")
    public suspend fun endPointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endPointName = mapped
    }

    /**
     * @param value IP Address (IPv4).
     */
    @JvmName("wtrirjhpnqvqwatp")
    public suspend fun ipAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param value TCP port to listen on to receive data.
     */
    @JvmName("hgfjuqfduebbhlyw")
    public suspend fun port(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Protocol either UDP or TCP.
     */
    @JvmName("pwjdilcwkxmijrnd")
    public suspend fun protocol(`value`: Either<String, Protocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol either UDP or TCP.
     */
    @JvmName("tuutwfuvsehnmohi")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Protocol either UDP or TCP.
     */
    @JvmName("fpgawhbkooargffo")
    public fun protocol(`value`: Protocol) {
        val toBeMapped = Either.ofRight<String, Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    internal fun build(): EndPointArgs = EndPointArgs(
        endPointName = endPointName ?: throw PulumiNullFieldException("endPointName"),
        ipAddress = ipAddress ?: throw PulumiNullFieldException("ipAddress"),
        port = port ?: throw PulumiNullFieldException("port"),
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
    )
}
