@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.GetEdgeSitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property edgeSiteName Edge site name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEdgeSitePlainArgs(
    public val edgeSiteName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.GetEdgeSitePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.GetEdgeSitePlainArgs =
        com.pulumi.azurenative.orbital.inputs.GetEdgeSitePlainArgs.builder()
            .edgeSiteName(edgeSiteName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEdgeSitePlainArgs].
 */
@PulumiTagMarker
public class GetEdgeSitePlainArgsBuilder internal constructor() {
    private var edgeSiteName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Edge site name.
     */
    @JvmName("ljaunjajjdjqfsmu")
    public suspend fun edgeSiteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.edgeSiteName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oojceihdrqijerpy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEdgeSitePlainArgs = GetEdgeSitePlainArgs(
        edgeSiteName = edgeSiteName ?: throw PulumiNullFieldException("edgeSiteName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
