@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.GetL2ConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property l2ConnectionName L2 Connection name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetL2ConnectionPlainArgs(
    public val l2ConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.GetL2ConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.GetL2ConnectionPlainArgs =
        com.pulumi.azurenative.orbital.inputs.GetL2ConnectionPlainArgs.builder()
            .l2ConnectionName(l2ConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetL2ConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetL2ConnectionPlainArgsBuilder internal constructor() {
    private var l2ConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value L2 Connection name.
     */
    @JvmName("igpqliwqtllpdeta")
    public suspend fun l2ConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.l2ConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ntlveypuesfrcwwv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetL2ConnectionPlainArgs = GetL2ConnectionPlainArgs(
        l2ConnectionName = l2ConnectionName ?: throw PulumiNullFieldException("l2ConnectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
