@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ListSpacecraftAvailableContactsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property contactProfile The reference to the contact profile resource.
 * @property endTime End time of a contact (ISO 8601 UTC standard).
 * @property groundStationName Name of Azure Ground Station.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spacecraftName Spacecraft ID.
 * @property startTime Start time of a contact (ISO 8601 UTC standard).
 */
public data class ListSpacecraftAvailableContactsPlainArgs(
    public val contactProfile: ContactParametersContactProfile,
    public val endTime: String,
    public val groundStationName: String,
    public val resourceGroupName: String,
    public val spacecraftName: String,
    public val startTime: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ListSpacecraftAvailableContactsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.orbital.inputs.ListSpacecraftAvailableContactsPlainArgs =
        com.pulumi.azurenative.orbital.inputs.ListSpacecraftAvailableContactsPlainArgs.builder()
            .contactProfile(contactProfile.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endTime(endTime.let({ args0 -> args0 }))
            .groundStationName(groundStationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .spacecraftName(spacecraftName.let({ args0 -> args0 }))
            .startTime(startTime.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSpacecraftAvailableContactsPlainArgs].
 */
@PulumiTagMarker
public class ListSpacecraftAvailableContactsPlainArgsBuilder internal constructor() {
    private var contactProfile: ContactParametersContactProfile? = null

    private var endTime: String? = null

    private var groundStationName: String? = null

    private var resourceGroupName: String? = null

    private var spacecraftName: String? = null

    private var startTime: String? = null

    /**
     * @param value The reference to the contact profile resource.
     */
    @JvmName("hrpnqlruyluljobk")
    public suspend fun contactProfile(`value`: ContactParametersContactProfile) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contactProfile = mapped
    }

    /**
     * @param argument The reference to the contact profile resource.
     */
    @JvmName("vspfefohrrwefprm")
    public suspend
    fun contactProfile(argument: suspend ContactParametersContactProfileBuilder.() -> Unit) {
        val toBeMapped = ContactParametersContactProfileBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.contactProfile = mapped
    }

    /**
     * @param value End time of a contact (ISO 8601 UTC standard).
     */
    @JvmName("tbkehitjhcesnxak")
    public suspend fun endTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value Name of Azure Ground Station.
     */
    @JvmName("lxgnorrpgecrpcmy")
    public suspend fun groundStationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groundStationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("esegfrkpypuauayq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Spacecraft ID.
     */
    @JvmName("oihelbrnygordwre")
    public suspend fun spacecraftName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spacecraftName = mapped
    }

    /**
     * @param value Start time of a contact (ISO 8601 UTC standard).
     */
    @JvmName("plhhnsktwssqcjyq")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): ListSpacecraftAvailableContactsPlainArgs =
        ListSpacecraftAvailableContactsPlainArgs(
            contactProfile = contactProfile ?: throw PulumiNullFieldException("contactProfile"),
            endTime = endTime ?: throw PulumiNullFieldException("endTime"),
            groundStationName = groundStationName ?: throw PulumiNullFieldException("groundStationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            spacecraftName = spacecraftName ?: throw PulumiNullFieldException("spacecraftName"),
            startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        )
}
