@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Contact Profile Link Channel.
 * @property bandwidthMHz Bandwidth in MHz.
 * @property centerFrequencyMHz Center Frequency in MHz.
 * @property decodingConfiguration Currently unused.
 * @property demodulationConfiguration Copy of the modem configuration file such as Kratos QRadio or Kratos QuantumRx. Only valid for downlink directions. If provided, the modem connects to the customer endpoint and sends demodulated data instead of a VITA.49 stream.
 * @property encodingConfiguration Currently unused.
 * @property endPoint Customer end point to store and retrieve data during a contact with the spacecraft.
 * @property modulationConfiguration Copy of the modem configuration file such as Kratos QRadio. Only valid for uplink directions. If provided, the modem connects to the customer endpoint and accepts commands from the customer instead of a VITA.49 stream.
 * @property name Channel name.
 */
public data class ContactProfileLinkChannelResponse(
    public val bandwidthMHz: Double,
    public val centerFrequencyMHz: Double,
    public val decodingConfiguration: String? = null,
    public val demodulationConfiguration: String? = null,
    public val encodingConfiguration: String? = null,
    public val endPoint: EndPointResponse,
    public val modulationConfiguration: String? = null,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.ContactProfileLinkChannelResponse):
            ContactProfileLinkChannelResponse = ContactProfileLinkChannelResponse(
            bandwidthMHz = javaType.bandwidthMHz(),
            centerFrequencyMHz = javaType.centerFrequencyMHz(),
            decodingConfiguration = javaType.decodingConfiguration().map({ args0 -> args0 }).orElse(null),
            demodulationConfiguration = javaType.demodulationConfiguration().map({ args0 ->
                args0
            }).orElse(null),
            encodingConfiguration = javaType.encodingConfiguration().map({ args0 -> args0 }).orElse(null),
            endPoint = javaType.endPoint().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.EndPointResponse.Companion.toKotlin(args0)
            }),
            modulationConfiguration = javaType.modulationConfiguration().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
        )
    }
}
