@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Connects an edge site to an orbital gateway and describes what layer 2 traffic to forward between them.
 * @property circuitId Globally-unique identifier for this connection that is to be used as a circuit ID.
 * @property edgeSite A reference to an Microsoft.Orbital/edgeSites resource to route traffic for.
 * @property groundStation A reference to an Microsoft.Orbital/groundStations resource to route traffic for.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vlanId The VLAN ID for the L2 connection.
 */
public data class GetL2ConnectionResult(
    public val circuitId: String,
    public val edgeSite: L2ConnectionsPropertiesResponseEdgeSite,
    public val groundStation: L2ConnectionsPropertiesResponseGroundStation,
    public val id: String,
    public val location: String,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vlanId: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.GetL2ConnectionResult):
            GetL2ConnectionResult = GetL2ConnectionResult(
            circuitId = javaType.circuitId(),
            edgeSite = javaType.edgeSite().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.L2ConnectionsPropertiesResponseEdgeSite.Companion.toKotlin(args0)
            }),
            groundStation = javaType.groundStation().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.L2ConnectionsPropertiesResponseGroundStation.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vlanId = javaType.vlanId(),
        )
    }
}
