@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.kotlin.outputs.ContactDetailResponse
import com.pulumi.azurenative.peering.kotlin.outputs.ContactDetailResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [PeerAsn].
 */
@PulumiTagMarker
public class PeerAsnResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PeerAsnArgs = PeerAsnArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PeerAsnArgsBuilder.() -> Unit) {
        val builder = PeerAsnArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PeerAsn {
        val builtJavaResource = com.pulumi.azurenative.peering.PeerAsn(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PeerAsn(builtJavaResource)
    }
}

/**
 * The essential information related to the peer's ASN.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2019-09-01-preview, 2021-01-01.
 * ## Example Usage
 * ### Create a peer ASN
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peerAsn = new AzureNative.Peering.PeerAsn("peerAsn", new()
 *     {
 *         PeerAsn = 65000,
 *         PeerAsnName = "peerAsnName",
 *         PeerContactDetail = new[]
 *         {
 *             new AzureNative.Peering.Inputs.ContactDetailArgs
 *             {
 *                 Email = "noc@contoso.com",
 *                 Phone = "+1 (234) 567-8999",
 *                 Role = AzureNative.Peering.Role.Noc,
 *             },
 *             new AzureNative.Peering.Inputs.ContactDetailArgs
 *             {
 *                 Email = "abc@contoso.com",
 *                 Phone = "+1 (234) 567-8900",
 *                 Role = AzureNative.Peering.Role.Policy,
 *             },
 *             new AzureNative.Peering.Inputs.ContactDetailArgs
 *             {
 *                 Email = "xyz@contoso.com",
 *                 Phone = "+1 (234) 567-8900",
 *                 Role = AzureNative.Peering.Role.Technical,
 *             },
 *         },
 *         PeerName = "Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewPeerAsn(ctx, "peerAsn", &peering.PeerAsnArgs{
 * 			PeerAsn:     pulumi.Int(65000),
 * 			PeerAsnName: pulumi.String("peerAsnName"),
 * 			PeerContactDetail: peering.ContactDetailArray{
 * 				&peering.ContactDetailArgs{
 * 					Email: pulumi.String("noc@contoso.com"),
 * 					Phone: pulumi.String("+1 (234) 567-8999"),
 * 					Role:  pulumi.String(peering.RoleNoc),
 * 				},
 * 				&peering.ContactDetailArgs{
 * 					Email: pulumi.String("abc@contoso.com"),
 * 					Phone: pulumi.String("+1 (234) 567-8900"),
 * 					Role:  pulumi.String(peering.RolePolicy),
 * 				},
 * 				&peering.ContactDetailArgs{
 * 					Email: pulumi.String("xyz@contoso.com"),
 * 					Phone: pulumi.String("+1 (234) 567-8900"),
 * 					Role:  pulumi.String(peering.RoleTechnical),
 * 				},
 * 			},
 * 			PeerName: pulumi.String("Contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.PeerAsn;
 * import com.pulumi.azurenative.peering.PeerAsnArgs;
 * import com.pulumi.azurenative.peering.inputs.ContactDetailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peerAsn = new PeerAsn("peerAsn", PeerAsnArgs.builder()
 *             .peerAsn(65000)
 *             .peerAsnName("peerAsnName")
 *             .peerContactDetail(
 *                 ContactDetailArgs.builder()
 *                     .email("noc@contoso.com")
 *                     .phone("+1 (234) 567-8999")
 *                     .role("Noc")
 *                     .build(),
 *                 ContactDetailArgs.builder()
 *                     .email("abc@contoso.com")
 *                     .phone("+1 (234) 567-8900")
 *                     .role("Policy")
 *                     .build(),
 *                 ContactDetailArgs.builder()
 *                     .email("xyz@contoso.com")
 *                     .phone("+1 (234) 567-8900")
 *                     .role("Technical")
 *                     .build())
 *             .peerName("Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:PeerAsn peerAsnName /subscriptions/{subscriptionId}/providers/Microsoft.Peering/peerAsns/{peerAsnName}
 * ```
 */
public class PeerAsn internal constructor(
    override val javaResource: com.pulumi.azurenative.peering.PeerAsn,
) : KotlinCustomResource(javaResource, PeerAsnMapper) {
    /**
     * The error message for the validation state
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Autonomous System Number (ASN) of the peer.
     */
    public val peerAsn: Output<Int>?
        get() = javaResource.peerAsn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The contact details of the peer.
     */
    public val peerContactDetail: Output<List<ContactDetailResponse>>?
        get() = javaResource.peerContactDetail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name of the peer.
     */
    public val peerName: Output<String>?
        get() = javaResource.peerName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The validation state of the ASN associated with the peer.
     */
    public val validationState: Output<String>
        get() = javaResource.validationState().applyValue({ args0 -> args0 })
}

public object PeerAsnMapper : ResourceMapper<PeerAsn> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.peering.PeerAsn::class == javaResource::class

    override fun map(javaResource: Resource): PeerAsn = PeerAsn(
        javaResource as
            com.pulumi.azurenative.peering.PeerAsn,
    )
}

/**
 * @see [PeerAsn].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PeerAsn].
 */
public suspend fun peerAsn(name: String, block: suspend PeerAsnResourceBuilder.() -> Unit):
    PeerAsn {
    val builder = PeerAsnResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PeerAsn].
 * @param name The _unique_ name of the resulting resource.
 */
public fun peerAsn(name: String): PeerAsn {
    val builder = PeerAsnResourceBuilder()
    builder.name(name)
    return builder.build()
}
