@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.PeerAsnArgs.builder
import com.pulumi.azurenative.peering.kotlin.inputs.ContactDetailArgs
import com.pulumi.azurenative.peering.kotlin.inputs.ContactDetailArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The essential information related to the peer's ASN.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2019-09-01-preview, 2021-01-01.
 * ## Example Usage
 * ### Create a peer ASN
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var peerAsn = new AzureNative.Peering.PeerAsn("peerAsn", new()
 *     {
 *         PeerAsn = 65000,
 *         PeerAsnName = "peerAsnName",
 *         PeerContactDetail = new[]
 *         {
 *             new AzureNative.Peering.Inputs.ContactDetailArgs
 *             {
 *                 Email = "noc@contoso.com",
 *                 Phone = "+1 (234) 567-8999",
 *                 Role = AzureNative.Peering.Role.Noc,
 *             },
 *             new AzureNative.Peering.Inputs.ContactDetailArgs
 *             {
 *                 Email = "abc@contoso.com",
 *                 Phone = "+1 (234) 567-8900",
 *                 Role = AzureNative.Peering.Role.Policy,
 *             },
 *             new AzureNative.Peering.Inputs.ContactDetailArgs
 *             {
 *                 Email = "xyz@contoso.com",
 *                 Phone = "+1 (234) 567-8900",
 *                 Role = AzureNative.Peering.Role.Technical,
 *             },
 *         },
 *         PeerName = "Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewPeerAsn(ctx, "peerAsn", &peering.PeerAsnArgs{
 * 			PeerAsn:     pulumi.Int(65000),
 * 			PeerAsnName: pulumi.String("peerAsnName"),
 * 			PeerContactDetail: peering.ContactDetailArray{
 * 				&peering.ContactDetailArgs{
 * 					Email: pulumi.String("noc@contoso.com"),
 * 					Phone: pulumi.String("+1 (234) 567-8999"),
 * 					Role:  pulumi.String(peering.RoleNoc),
 * 				},
 * 				&peering.ContactDetailArgs{
 * 					Email: pulumi.String("abc@contoso.com"),
 * 					Phone: pulumi.String("+1 (234) 567-8900"),
 * 					Role:  pulumi.String(peering.RolePolicy),
 * 				},
 * 				&peering.ContactDetailArgs{
 * 					Email: pulumi.String("xyz@contoso.com"),
 * 					Phone: pulumi.String("+1 (234) 567-8900"),
 * 					Role:  pulumi.String(peering.RoleTechnical),
 * 				},
 * 			},
 * 			PeerName: pulumi.String("Contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.PeerAsn;
 * import com.pulumi.azurenative.peering.PeerAsnArgs;
 * import com.pulumi.azurenative.peering.inputs.ContactDetailArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var peerAsn = new PeerAsn("peerAsn", PeerAsnArgs.builder()
 *             .peerAsn(65000)
 *             .peerAsnName("peerAsnName")
 *             .peerContactDetail(
 *                 ContactDetailArgs.builder()
 *                     .email("noc@contoso.com")
 *                     .phone("+1 (234) 567-8999")
 *                     .role("Noc")
 *                     .build(),
 *                 ContactDetailArgs.builder()
 *                     .email("abc@contoso.com")
 *                     .phone("+1 (234) 567-8900")
 *                     .role("Policy")
 *                     .build(),
 *                 ContactDetailArgs.builder()
 *                     .email("xyz@contoso.com")
 *                     .phone("+1 (234) 567-8900")
 *                     .role("Technical")
 *                     .build())
 *             .peerName("Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:PeerAsn peerAsnName /subscriptions/{subscriptionId}/providers/Microsoft.Peering/peerAsns/{peerAsnName}
 * ```
 * @property peerAsn The Autonomous System Number (ASN) of the peer.
 * @property peerAsnName The peer ASN name.
 * @property peerContactDetail The contact details of the peer.
 * @property peerName The name of the peer.
 */
public data class PeerAsnArgs(
    public val peerAsn: Output<Int>? = null,
    public val peerAsnName: Output<String>? = null,
    public val peerContactDetail: Output<List<ContactDetailArgs>>? = null,
    public val peerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.PeerAsnArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.PeerAsnArgs =
        com.pulumi.azurenative.peering.PeerAsnArgs.builder()
            .peerAsn(peerAsn?.applyValue({ args0 -> args0 }))
            .peerAsnName(peerAsnName?.applyValue({ args0 -> args0 }))
            .peerContactDetail(
                peerContactDetail?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .peerName(peerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeerAsnArgs].
 */
@PulumiTagMarker
public class PeerAsnArgsBuilder internal constructor() {
    private var peerAsn: Output<Int>? = null

    private var peerAsnName: Output<String>? = null

    private var peerContactDetail: Output<List<ContactDetailArgs>>? = null

    private var peerName: Output<String>? = null

    /**
     * @param value The Autonomous System Number (ASN) of the peer.
     */
    @JvmName("fwidkgdwdheggvdy")
    public suspend fun peerAsn(`value`: Output<Int>) {
        this.peerAsn = value
    }

    /**
     * @param value The peer ASN name.
     */
    @JvmName("dhhmdmihkcahfeew")
    public suspend fun peerAsnName(`value`: Output<String>) {
        this.peerAsnName = value
    }

    /**
     * @param value The contact details of the peer.
     */
    @JvmName("rgcapafiardghqly")
    public suspend fun peerContactDetail(`value`: Output<List<ContactDetailArgs>>) {
        this.peerContactDetail = value
    }

    @JvmName("efsshspturifhfgr")
    public suspend fun peerContactDetail(vararg values: Output<ContactDetailArgs>) {
        this.peerContactDetail = Output.all(values.asList())
    }

    /**
     * @param values The contact details of the peer.
     */
    @JvmName("bmqfklwkgksrpujp")
    public suspend fun peerContactDetail(values: List<Output<ContactDetailArgs>>) {
        this.peerContactDetail = Output.all(values)
    }

    /**
     * @param value The name of the peer.
     */
    @JvmName("mnodoottteigmeux")
    public suspend fun peerName(`value`: Output<String>) {
        this.peerName = value
    }

    /**
     * @param value The Autonomous System Number (ASN) of the peer.
     */
    @JvmName("mamluiaqmninribu")
    public suspend fun peerAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param value The peer ASN name.
     */
    @JvmName("dporvjjhcxhlvsjs")
    public suspend fun peerAsnName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsnName = mapped
    }

    /**
     * @param value The contact details of the peer.
     */
    @JvmName("wfjvgppewrlfbugh")
    public suspend fun peerContactDetail(`value`: List<ContactDetailArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerContactDetail = mapped
    }

    /**
     * @param argument The contact details of the peer.
     */
    @JvmName("ghlvcqlsnrwstawo")
    public suspend
    fun peerContactDetail(argument: List<suspend ContactDetailArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContactDetailArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.peerContactDetail = mapped
    }

    /**
     * @param argument The contact details of the peer.
     */
    @JvmName("fakigccgopipwvfh")
    public suspend fun peerContactDetail(
        vararg
        argument: suspend ContactDetailArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContactDetailArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.peerContactDetail = mapped
    }

    /**
     * @param argument The contact details of the peer.
     */
    @JvmName("jvoayffgwxrqfgwi")
    public suspend fun peerContactDetail(argument: suspend ContactDetailArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContactDetailArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.peerContactDetail = mapped
    }

    /**
     * @param values The contact details of the peer.
     */
    @JvmName("rfxwbfrxluxapuii")
    public suspend fun peerContactDetail(vararg values: ContactDetailArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerContactDetail = mapped
    }

    /**
     * @param value The name of the peer.
     */
    @JvmName("yufjsoqfqeplppiv")
    public suspend fun peerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerName = mapped
    }

    internal fun build(): PeerAsnArgs = PeerAsnArgs(
        peerAsn = peerAsn,
        peerAsnName = peerAsnName,
        peerContactDetail = peerContactDetail,
        peerName = peerName,
    )
}
