@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RegisteredPrefix].
 */
@PulumiTagMarker
public class RegisteredPrefixResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegisteredPrefixArgs = RegisteredPrefixArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegisteredPrefixArgsBuilder.() -> Unit) {
        val builder = RegisteredPrefixArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegisteredPrefix {
        val builtJavaResource = com.pulumi.azurenative.peering.RegisteredPrefix(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegisteredPrefix(builtJavaResource)
    }
}

/**
 * The customer's prefix that is registered by the peering service provider.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create or update a registered prefix for the peering
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registeredPrefix = new AzureNative.Peering.RegisteredPrefix("registeredPrefix", new()
 *     {
 *         PeeringName = "peeringName",
 *         Prefix = "10.22.20.0/24",
 *         RegisteredPrefixName = "registeredPrefixName",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewRegisteredPrefix(ctx, "registeredPrefix", &peering.RegisteredPrefixArgs{
 * 			PeeringName:          pulumi.String("peeringName"),
 * 			Prefix:               pulumi.String("10.22.20.0/24"),
 * 			RegisteredPrefixName: pulumi.String("registeredPrefixName"),
 * 			ResourceGroupName:    pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.RegisteredPrefix;
 * import com.pulumi.azurenative.peering.RegisteredPrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registeredPrefix = new RegisteredPrefix("registeredPrefix", RegisteredPrefixArgs.builder()
 *             .peeringName("peeringName")
 *             .prefix("10.22.20.0/24")
 *             .registeredPrefixName("registeredPrefixName")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:RegisteredPrefix registeredPrefixName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/registeredPrefixes/{registeredPrefixName}
 * ```
 */
public class RegisteredPrefix internal constructor(
    override val javaResource: com.pulumi.azurenative.peering.RegisteredPrefix,
) : KotlinCustomResource(javaResource, RegisteredPrefixMapper) {
    /**
     * The error message associated with the validation state, if any.
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The peering service prefix key that is to be shared with the customer.
     */
    public val peeringServicePrefixKey: Output<String>
        get() = javaResource.peeringServicePrefixKey().applyValue({ args0 -> args0 })

    /**
     * The customer's prefix from which traffic originates.
     */
    public val prefix: Output<String>?
        get() = javaResource.prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The prefix validation state.
     */
    public val prefixValidationState: Output<String>
        get() = javaResource.prefixValidationState().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegisteredPrefixMapper : ResourceMapper<RegisteredPrefix> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.peering.RegisteredPrefix::class == javaResource::class

    override fun map(javaResource: Resource): RegisteredPrefix = RegisteredPrefix(
        javaResource as
            com.pulumi.azurenative.peering.RegisteredPrefix,
    )
}

/**
 * @see [RegisteredPrefix].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegisteredPrefix].
 */
public suspend fun registeredPrefix(
    name: String,
    block: suspend RegisteredPrefixResourceBuilder.() -> Unit,
): RegisteredPrefix {
    val builder = RegisteredPrefixResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegisteredPrefix].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registeredPrefix(name: String): RegisteredPrefix {
    val builder = RegisteredPrefixResourceBuilder()
    builder.name(name)
    return builder.build()
}
