@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.ExchangeConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties that define an exchange connection.
 * @property bgpSession The BGP session associated with the connection.
 * @property connectionIdentifier The unique identifier (GUID) for the connection.
 * @property peeringDBFacilityId The PeeringDB.com ID of the facility at which the connection has to be set up.
 */
public data class ExchangeConnectionArgs(
    public val bgpSession: Output<BgpSessionArgs>? = null,
    public val connectionIdentifier: Output<String>? = null,
    public val peeringDBFacilityId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.ExchangeConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.ExchangeConnectionArgs =
        com.pulumi.azurenative.peering.inputs.ExchangeConnectionArgs.builder()
            .bgpSession(bgpSession?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionIdentifier(connectionIdentifier?.applyValue({ args0 -> args0 }))
            .peeringDBFacilityId(peeringDBFacilityId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExchangeConnectionArgs].
 */
@PulumiTagMarker
public class ExchangeConnectionArgsBuilder internal constructor() {
    private var bgpSession: Output<BgpSessionArgs>? = null

    private var connectionIdentifier: Output<String>? = null

    private var peeringDBFacilityId: Output<Int>? = null

    /**
     * @param value The BGP session associated with the connection.
     */
    @JvmName("mgoeceavnwhthdwc")
    public suspend fun bgpSession(`value`: Output<BgpSessionArgs>) {
        this.bgpSession = value
    }

    /**
     * @param value The unique identifier (GUID) for the connection.
     */
    @JvmName("ioqxheasexuqfshp")
    public suspend fun connectionIdentifier(`value`: Output<String>) {
        this.connectionIdentifier = value
    }

    /**
     * @param value The PeeringDB.com ID of the facility at which the connection has to be set up.
     */
    @JvmName("jnkvgswcwftyaloj")
    public suspend fun peeringDBFacilityId(`value`: Output<Int>) {
        this.peeringDBFacilityId = value
    }

    /**
     * @param value The BGP session associated with the connection.
     */
    @JvmName("dulehgjnpthhldav")
    public suspend fun bgpSession(`value`: BgpSessionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpSession = mapped
    }

    /**
     * @param argument The BGP session associated with the connection.
     */
    @JvmName("acncwkainomqplwd")
    public suspend fun bgpSession(argument: suspend BgpSessionArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSessionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpSession = mapped
    }

    /**
     * @param value The unique identifier (GUID) for the connection.
     */
    @JvmName("aboldvynxchywhay")
    public suspend fun connectionIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionIdentifier = mapped
    }

    /**
     * @param value The PeeringDB.com ID of the facility at which the connection has to be set up.
     */
    @JvmName("kgiskdlysqdtdwms")
    public suspend fun peeringDBFacilityId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringDBFacilityId = mapped
    }

    internal fun build(): ExchangeConnectionArgs = ExchangeConnectionArgs(
        bgpSession = bgpSession,
        connectionIdentifier = connectionIdentifier,
        peeringDBFacilityId = peeringDBFacilityId,
    )
}
