@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.GetPeeringPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peeringName The name of the peering.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPeeringPlainArgs(
    public val peeringName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.GetPeeringPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.GetPeeringPlainArgs =
        com.pulumi.azurenative.peering.inputs.GetPeeringPlainArgs.builder()
            .peeringName(peeringName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPeeringPlainArgs].
 */
@PulumiTagMarker
public class GetPeeringPlainArgsBuilder internal constructor() {
    private var peeringName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the peering.
     */
    @JvmName("gexsvcushtaegorc")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vpcnewgrkrtyakqr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPeeringPlainArgs = GetPeeringPlainArgs(
        peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
